package jp.sourceforge.sxdbutils.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;

/**
 * コンストラクタにkeyにプロパティ名を、valueにカラム名をセットしたMapを渡すことができる {@link NameMapping} です。
 * 
 * @author chinpei
 * 
 */
public class OverwriteNameMapping implements NameMapping {

	private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();

	protected final Map propertyToColumnMap;
	protected final Map columnToPropertyMap = this.createIntermediateMap();

	protected final NameMapping defaultNameMapping;

	public OverwriteNameMapping(Map propertyToColumnMap) {
		this(propertyToColumnMap, DEFAULT_COMVERSION);
	}

	public OverwriteNameMapping(Map propertyToColumnMap,
			NameMapping defaultNameMapping) {
		this.propertyToColumnMap = new HashMap(propertyToColumnMap);
		for (Iterator iterator = this.propertyToColumnMap.entrySet().iterator(); iterator
				.hasNext();) {
			Map.Entry entry = (Map.Entry) iterator.next();
			columnToPropertyMap.put(entry.getValue(), entry.getKey());
		}
		this.defaultNameMapping = defaultNameMapping;
	}

	public String toIntermediateNameFromAttrName(String bindObjectName) {
		return (this.propertyToColumnMap.containsKey(bindObjectName)) ? bindObjectName
				: defaultNameMapping
						.toIntermediateNameFromAttrName(bindObjectName);
	}

	public String toColumnNameFromAttrName(String bindObjectName) {
		return (this.propertyToColumnMap.containsKey(bindObjectName)) ? (String) this.propertyToColumnMap
				.get(bindObjectName)
				: defaultNameMapping
						.toColumnNameFromAttrName(bindObjectName);
	}

	public final Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateNameFromColumnName(String columnName) {
		String name = (String) columnToPropertyMap.get(columnName);
		return name == null ? defaultNameMapping
				.toIntermediateNameFromColumnName(columnName) : name;
	}
}
