package jp.sourceforge.sxdbutils.processors;

import java.util.Map;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.PropertyAttributeDescpriotr;

/**
 * Beanにマッピングする {@link SxRowProcessor}。 カラム名とプロパティ名の名前が、 {@link NameMapping}
 * によって一致したものがマッピングされます。 デフォルトでは、カラム名でマッピングされます。
 * 
 * @author chinpei
 * 
 */
public class BeanRowProcessor extends AttributeRowProcessor {

	public BeanRowProcessor(Class clazz, NameMapping nameMapping) {
		super(clazz, nameMapping);
	}

	public BeanRowProcessor(Class beanClass) {
		super(beanClass);
	}

	protected void putDescriptorToMap(Class clazz,
			Map descriptorMap) {
		PropertyAttributeDescpriotr.putDescriptorToMap(clazz, descriptorMap);
	}
	/**
	 * マッピング対象クラスを返します。
	 * 
	 * @return
	 */
	public Class getBeanClass() {
		return baseClass;
	}
}
