package jp.sourceforge.sxdbutils.types;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.util.OthersUtils;


public class StringClobType extends AbstractValueType {
	/*
	 * (non-Javadoc)
	 * 
	 * @see dbutilsx.types.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		Reader reader = null;
		try {
			reader = rset.getCharacterStream(columnIndex);
			if (reader == null)
				return null;
			return OthersUtils.toString(reader);
		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			OthersUtils.closeQuietly(reader);
		}
	}

	// protected int getSqlType() {
	// return Types.CLOB;
	// }

}
