package jp.sourceforge.sxdbutils.query;

import jp.sourceforge.sxdbutils.meta.PersistenceEntry;

public class AttributeQueryFactory implements QueryFactory {
	private final String sql;
	private final PersistenceEntry[] entries;

	AttributeQueryFactory(String sql, PersistenceEntry[] entries) {
		this.sql = sql;
		this.entries = entries;
	}

	public Query toQuery(Object object) {
		SimpleQueryBuilder builder = new SimpleQueryBuilder(this.sql);
		for (int i = 0; i < entries.length; i++) {
			builder.bind(entries[i].read(object));
		}
		return builder.toQuery();
	}

	public String getSql() {
		return this.sql;
	}

	public Object[] toBindParameters(Object object) {
		Object[] params = new Object[entries.length];
		for (int i = 0; i < entries.length; i++) {
			params[i] = entries[i].read(object);
		}
		return params;
	}

}
