package jp.sourceforge.sxdbutils.query;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.BasicPersistenceEntry;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;
import jp.sourceforge.sxdbutils.meta.PropertyAttributeDescpriotr;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/**
 * BeanQueryFactoryのビルダーです。
 * 
 * @author chinpei
 * 
 */
public class BeanQueryFactoryBuilder extends AttributeQueryFactoryBuilder {

	public BeanQueryFactoryBuilder(Class baseClass) {
		super(baseClass);
	}

	public BeanQueryFactoryBuilder(Class baseClass, NameMapping nameMapping) {
		super(baseClass, nameMapping);
	}

	public BeanQueryFactoryBuilder excludeColumn(String excludeColumn) {
		excludeColumns.add(excludeColumn.toLowerCase());
		return this;
	}

	public BeanQueryFactoryBuilder excludeColumns(String[] excludeColumns) {
		for (int i = 0; i < excludeColumns.length; i++)
			excludeColumn(excludeColumns[i]);
		return this;
	}

	public BeanQueryFactoryBuilder excludeColumns(List excludeColumns) {
		for (int i = 0; i < excludeColumns.size(); i++)
			excludeColumn((String) excludeColumns.get(i));
		return this;
	}

	public BeanQueryFactoryBuilder tableName(String tableName) {
		this.tableName = tableName;
		return this;
	}

	public BeanQueryFactoryBuilder versionColumnName(String versionColumnName) {
		this.versionColumnName = versionColumnName;
		return this;
	}

	public BeanQueryFactoryBuilder columnType(String columnName, int sqlType) {
		columnTypeMap.put(columnName.toLowerCase(), new Integer(sqlType));
		return this;
	}

	public BeanQueryFactoryBuilder whereKeyColumn(String columnNames) {
		if (this.whereKeyColumnSet == null) {
			this.whereKeyColumnSet = new LinkedHashSet();
		}
		this.whereKeyColumnSet.add(columnNames.toLowerCase());
		return this;
	}

	protected PersistenceEntry[] toPersistenceEntries() {
		PropertyDescriptor[] propertyDescriptors = ReflectionUtil
				.propertyDescriptors(baseClass);

		List persistenceEntries = new ArrayList();
		for (int i = 0; i < propertyDescriptors.length; i++) {
			AttributeDescpriotr attributeDescpriotr = new PropertyAttributeDescpriotr(
					propertyDescriptors[i]);
			if (!attributeDescpriotr.isReadable()
					|| "class".equals(attributeDescpriotr.getName()))
				continue;

			String columnName = this.nameMapping
					.toColumnNameFromAttrName(attributeDescpriotr.getName());
			if (excludeColumns.contains(columnName.toLowerCase()))
				continue;

			// ValueType取得
			Integer sqlType = (Integer) columnTypeMap.get(columnName
					.toLowerCase());

			ValueType valueType = getValueType(attributeDescpriotr, sqlType);

			BasicPersistenceEntry entry = new BasicPersistenceEntry(columnName,
					valueType, attributeDescpriotr);

			persistenceEntries.add(entry);
		}
		return (PersistenceEntry[]) persistenceEntries
				.toArray(new PersistenceEntry[persistenceEntries.size()]);
	}

}
