package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.template.EntityPersistenceHelper;

public abstract class AbstractUpdateTemplate implements UpdateTemplate {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory updateFactory;
	protected EntityPersistenceHelper persistenceHelper = new EntityPersistenceHelper();

	public AbstractUpdateTemplate(QueryFactory updateFactory) {
		this.updateFactory = updateFactory;
	}

	public int[] update(Collection entities) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, entities);
	}

	public int update(Object entity) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, entity);
	}

	public int[] updateBatch(Collection entities) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), updateFactory,
				entities);
	}
}
