package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.bean.BeanPersistenceHelper;

public abstract class AbstractUpdateTemplate<E> implements UpdateTemplate<E> {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory updateFactory;
	protected BeanPersistenceHelper<E> persistenceHelper = new BeanPersistenceHelper<E>();

	public AbstractUpdateTemplate(QueryFactory updateFactory) {
		this.updateFactory = updateFactory;
	}

	public int[] update(Collection<E> entites) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, entites);
	}

	public int update(E entity) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, entity);
	}

	public int[] updateBatch(Collection<E> entites) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), updateFactory,
				entites);
	}
}
