package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.SxQueryRunner;

public class EntityPersistenceHelper<E> {

	public int execute(Connection connection, QueryFactory factory, E entity)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.update(connection, factory.toQuery(entity));
	}

	public int[] execute(Connection connection, QueryFactory factory,
			Collection<E> entities) throws SQLException {
		List<Query> queries = new ArrayList<Query>();
		for (E entity : entities) {
			Query q = factory.toQuery(entity);
			queries.add(q);
		}
		int[] result = new int[queries.size()];
		SxQueryRunner runner = new SxQueryRunner();
		for (int i = 0; i < queries.size(); i++) {
			result[i] = runner.update(connection, queries.get(i));
		}
		return result;

	}

	public int[] executeBatch(Connection connection, QueryFactory factory,
			Collection<E> entities) throws SQLException {
		Object[][] batchParams = new Object[entities.size()][];
		int i = 0;
		for (E entity : entities) {
			batchParams[i++] = factory.toBindParameters(entity);
		}
		SxQueryRunner runner = new SxQueryRunner();
		return runner.batch(connection, factory.getSql(), batchParams);
	}

}
