package jp.sourceforge.sxdbutils.tiger.template.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;
@Deprecated
public abstract class AbstractCrudTemplate<E> implements CrudTemplate<E> {

	protected abstract Connection getConnection() throws SQLException;

	protected abstract Class<E> getBeanClass();

	protected abstract <X extends E> SxRowProcessor<X> createBeanProcessor(
			Class<X> beanClass);

	protected class InsertTemplateImpl extends AbstractInsertTemplate<E> {
		public InsertTemplateImpl(QueryFactory insertFactory) {
			super(insertFactory);
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class UpdateTemplateImpl extends AbstractUpdateTemplate<E> {
		public UpdateTemplateImpl(QueryFactory updateFactory) {
			super(updateFactory);
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class DeleteTemplateImpl extends AbstractDeleteTemplate<E> {
		public DeleteTemplateImpl(QueryFactory deleteFactory) {
			super(deleteFactory);
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class SelectTemplateImpl extends AbstractSelectTemplate<E> {
		@Override
		protected <X extends E> SxRowProcessor<X> createBeanProcessor(
				Class<X> beanClass) {
			return AbstractCrudTemplate.this.createBeanProcessor(beanClass);
		}

		@Override
		protected Class<E> getBeanClass() {
			return AbstractCrudTemplate.this.getBeanClass();
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected final SelectTemplate<E> selectTemplate;
	protected final InsertTemplate<E> insertTemplate;
	protected final UpdateTemplate<E> updateTemplate;
	protected final DeleteTemplate<E> deleteTemplate;

	public AbstractCrudTemplate(QueryFactory insertFactory,
			QueryFactory updateFactory, QueryFactory deleteFactory) {
		this.selectTemplate = new SelectTemplateImpl();
		this.insertTemplate = new InsertTemplateImpl(insertFactory);
		this.updateTemplate = new UpdateTemplateImpl(updateFactory);
		this.deleteTemplate = new DeleteTemplateImpl(deleteFactory);

	}

	public int[] delete(Collection<E> beans) throws SQLException {
		return deleteTemplate.delete(beans);
	}

	public int delete(E bean) throws SQLException {
		return deleteTemplate.delete(bean);
	}

	public int[] deleteBatch(Collection<E> beans) throws SQLException {
		return deleteTemplate.deleteBatch(beans);
	}

	public int insert(E bean) throws SQLException {
		return insertTemplate.insert(bean);
	}

	public int[] insert(Collection<E> beans) throws SQLException {
		return insertTemplate.insert(beans);
	}

	public int[] insertBatch(Collection<E> beans) throws SQLException {
		return insertTemplate.insertBatch(beans);
	}

	public <X extends E> X executeQueryToBean(Query query, Class<X> beanClass)
			throws SQLException {
		return selectTemplate.executeQueryToBean(query, beanClass);
	}

	public E executeQueryToBean(Query query) throws SQLException {
		return selectTemplate.executeQueryToBean(query);
	}

	public <X extends E> List<X> executeQueryToBeanList(Query query,
			Class<X> beanClass) throws SQLException {
		return selectTemplate.executeQueryToBeanList(query, beanClass);
	}

	public List<E> executeQueryToBeanList(Query query) throws SQLException {
		return selectTemplate.executeQueryToBeanList(query);
	}

	public int[] update(Collection<E> beans) throws SQLException {
		return updateTemplate.update(beans);
	}

	public int update(E bean) throws SQLException {
		return updateTemplate.update(bean);
	}

	public int[] updateBatch(Collection<E> beans) throws SQLException {
		return updateTemplate.updateBatch(beans);
	}

}
