/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sourceforge.sxdbutils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;

import javax.sql.DataSource;

import jp.sourceforge.sxdbutils.query.Query;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

/**
 * {@link Query}を指定出来る、{@link QueryRunner}の拡張クラスです。
 * 
 * @author chinpei
 * 
 */
public class SxQueryRunner extends QueryRunner {


	public SxQueryRunner() {
		super();
		ds = null;
	}

	public SxQueryRunner(DataSource ds) {
		super(ds);
	}

	/**
	 * commons-dbutilsのtrunkより。
	 */
	public SxQueryRunner(DataSource ds, boolean pmdKnownBroken) {
		super();
		this.ds = ds;
	}

	public Object query(Connection conn, Query query, ResultSetHandler rsh)
			throws SQLException {
		return super.query(conn, query.getSql(), query.getParameters(), rsh);
	}

	public Object query(Query query, ResultSetHandler rsh) throws SQLException {
		return super.query(query.getSql(), query.getParameters(), rsh);
	}

	public int update(Query query) throws SQLException {
		return this.update(query.getSql(), query.getParameters());
	}

	public int update(Connection conn, Query query) throws SQLException {
		return this.update(conn, query.getSql(), query.getParameters());
	}


	/**
	 * commons-dbutilsのtrunkより。
	 */
	protected void rethrow(SQLException cause, String sql, Object[] params)
			throws SQLException {

		String causeMessage = cause.getMessage();
		if (causeMessage == null) {
			causeMessage = "";
		}
		StringBuffer msg = new StringBuffer(causeMessage);

		msg.append(" Query: ");
		msg.append(sql);
		msg.append(" Parameters: ");

		if (params == null) {
			msg.append("[]");
		} else {
			msg.append(Arrays.asList(params));
		}

		SQLException e = new SQLException(msg.toString(), cause.getSQLState(),
				cause.getErrorCode());
		e.setNextException(cause);

		throw e;
	}
}
