<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterDebughtml.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륿饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Filter.php';

/**
 * ǥХåɽե륿饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterDebughtml.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FilterDebughtml extends SyL_Filter
{
    /**
     * ɽǼ
     *
     * @access public
     * @var array ɽǼ
     */
    var $view_info = array(
        'GET'      => true,
        'POST'     => true,
        'COOKIE'   => true,
        'SESSION'  => true,
        'SERVER'   => true,
        'ENV'      => true,
        'INCLUDE'  => true,
        'CONSTANT' => false,
        'FUNCTION' => true,
        'CLASS'    => true,
        'MODULE'   => true
    );

    /**
     * ӥ塼ɽե륿
     *
     * @access public
     * @param object ꥯȥ֥
     * @param object ӥ塼ǡ֥
     */
    function renderAfter()
    {
        echo "<hr>";
        echo "<h3>***** ǥХå *****</h3>";

        // ꥽
        echo "<h4>꥽</h4>\r\n";
        echo "<table border='1' cellspacing='0' cellpadding='2'>\r\n";
        echo "<tr>\r\n";
        echo "<td>ѥ᡼̾</td><td>ѥ᡼</td>\r\n";
        echo "</tr>\r\n";
        echo "<tr>\r\n";
        echo "<td></td><td>ѥ᡼</td>\r\n";
        echo "</tr>\r\n";
/*
        echo '<tr><td>ץȤμ¹Լ</td><td>' . '' . '</td></tr>' . "\r\n";
        echo '<tr><td>ߤΥץȤμ¹Ի</td><td>' . '' . '</td></tr>' . "\r\n";
        echo '<tr><td>ߤΥץȤλѥ</td><td>' . (function_exists('memory_get_usage') ? memory_get_usage() : '') . '</td></tr>' . "\r\n";
*/
        echo '</table>' . "\r\n";
        echo '<br>' . "\r\n";

        // GETɽȽ
        if ($this->view_info['GET'] && isset($_GET)) {
            $this->viewDebugInfoCategory('$_GET', $_GET);
        }

        // POSTɽȽ
        if ($this->view_info['POST'] && isset($_POST)) {
            $this->viewDebugInfoCategory('$_POST', $_POST);
        }

        // COOKIEɽȽ
        if ($this->view_info['COOKIE'] && isset($_COOKIE)) {
            $this->viewDebugInfoCategory('$_COOKIE', $_COOKIE);
        }

        // SESSIONɽȽ
        if ($this->view_info['SESSION'] && isset($_SESSION)) {
            $this->viewDebugInfoCategory('$_SESSION', $_SESSION);
        }

        // SERVERɽȽ
        if ($this->view_info['SERVER'] && isset($_SERVER)) {
            $this->viewDebugInfoCategory('$_SERVER', $_SERVER);
        }

        // ENVɽȽ
        if ($this->view_info['ENV'] && isset($_ENV)) {
            $this->viewDebugInfoCategory('$_ENV', $_ENV);
        }

        // 󥯥롼ɥեɽȽ
        if ($this->view_info['INCLUDE']) {
            $include_list = get_included_files();
            //sort($include_list);
            $this->viewDebugInfoCategory('INCLUDE', $include_list);
        }

        // ɽȽ
        if ($this->view_info['CONSTANT']) {
            $this->viewDebugInfoCategory('CONSTANT', get_defined_constants());
        }

        // ؿɽȽ
        if ($this->view_info['FUNCTION']) {
            $function_list = get_defined_functions();
            if (isset($function_list['user'])) {
                $this->viewDebugInfoCategory('FUNCTION', $function_list['user']);
            }
        }

        // 饹ɽȽ
        if ($this->view_info['CLASS']) {
            $class_list = get_declared_classes();
            //sort($class_list);
            $this->viewDebugInfoCategory('CLASS', $class_list);
        }

        // ⥸塼ɽȽ
        if ($this->view_info['MODULE']) {
            $module_list = get_loaded_extensions();
            //sort($module_list);
            $this->viewDebugInfoCategory('MODULE', $module_list);
        }


        echo "<br><br><br><br><br><br><br><br>\r\n";
    }

    /**
     * ǥХå󥫥ƥɽ
     *
     * @access public
     * @param array ɽоݥƥ̾
     * @param array ɽоݥƥ
     */
    function viewDebugInfoCategory($category_name, &$category_list)
    {
        echo "<h4>{$category_name}</h4>\r\n";
        echo "<table border='1' cellspacing='0' cellpadding='2'>\r\n";
        echo "<tr>\r\n";
        echo "<td bgcolor='#003399'><font color='#FFFFFF'><b>ѥ᡼̾</b></font></td>\r\n";
        echo "<td bgcolor='#003399'><font color='#FFFFFF'><b>ѥ᡼</b></font></td>\r\n";
        echo "</tr>\r\n";
        foreach ($category_list as $key => $value) {
            echo "<tr>\r\n";
            echo "<td>" . htmlspecialchars(var_export($key, true)) . "</td>\r\n";
            echo "<td>" . nl2br(str_replace(' ', '&nbsp;', htmlspecialchars(var_export($value, true)))) . "</td>\r\n";
            echo "</tr>\r\n";
        }
        echo "</table>\r\n";
        echo "<br>\r\n";
    }

}

?>
