<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Хåե
 */
ob_start();
/**
 * magic_quotes_runtime -> off
 */
set_magic_quotes_runtime(0);
/**
 * PHPƥ२顼¸
 */
if (SYL_CONFIG_SYSTEM_ERROR_LOG) {
    ini_set('log_errors', SYL_CONFIG_SYSTEM_ERROR_LOG);
    ini_set('error_log', SYL_CONFIG_SYSTEM_ERROR_LOG_FILE);
}

/**
 * 饤֥ǥ쥯ȥΥ󥯥롼ɥѥå
 */
set_include_path(get_include_path() . PATH_SEPARATOR . SYL_INCLUDE_DIR);

/**
 * եɤ߹९饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_DefinesReader.php';
/**
 * ܾ󥯥饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Forward.php';
/**
 * ƥʥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Container.php';

/**
 * ȥ饯饹
 *
 * Τνή
 * Ƥ
 *   DIƥʤݻ
 *   ήȼܥ٥Ƚ
 * 
 * ++ ܥ٥
 *   1. initStream         - ȥ顼Υ󥹥ȥ饯¹Ը
 *   2.   loadStream       - ¹
 *   3.     executeStream  - ¹
 *   4.       middleStream - ¹Ը塢ӥ塼ɽ¹
 *   5.     renderStream   - ӥ塼ɽ¹
 *   6.   unloadStream     - ӥ塼ɽ¹Ը
 *   7. finalStream        - shutdown
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Controller
{
    /**
     * ץꥱ̾
     * webapp/(ץꥱ̾)/...
     *
     * @access public
     * @var string
     */
    var $app_name = '';
    /**
     * ǥ쥯ȥ롼
     *
     * @access protected
     * @var string
     */
    var $action_dir = '';
    /**
     * ƥץ졼ȥǥ쥯ȥ롼
     *
     * @access protected
     * @var string
     */
    var $template_dir = '';
    /**
     * ¹Ƚ
     * 
     * @access private
     * @var bool
     */
    var $is_execute_action = true;
    /**
     * ƥʥ֥
     *
     * @access protected
     * @var object
     */
    var $container = null;
    /**
     * ˴᥽å̾
     * ''ξϽ˴᥽åɤưʤ
     *
     * @access protected
     * @var string
     */
    var $destory_method = 'finalStream';
    /**
     * ˴֥
     *
     * @access protected
     * @var array
     */
    var $destory_objects = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Controller()
    {
        if ($this->app_name == '') {
            trigger_error("[SyL error] App_name not exists", E_USER_ERROR);
        }

        // ץꥱǥ쥯ȥ
        define('SYL_APP_DIR', SYL_WEBAPP_DIR . '/' . $this->app_name);

        // shutdown᥽å
        if ($this->destory_method != '') {
            register_shutdown_function(array(&$this, $this->destory_method));
        }

        // 󡢥ƥץ졼ȥǥ쥯ȥ
        if ($this->action_dir == '') {
            $this->action_dir = SYL_APP_DIR . '/actions';
        }
        if ($this->template_dir == '') {
            $this->template_dir = SYL_APP_DIR . '/templates';
        }

        // ɤ߹
        SyL_DefinesReader::readConfig($this);

        // ƥ
        $this->container =& new SyL_Container();
        $this->container->setComponent(SYL_CONFIG_CONTROLLER_NAME, $this);
    }

    /**
     * 
     *
     * @access protected
     */
    function initStream()
    {
        // Х륳ݡͥե
        $config_file = array(
          'components' => SYL_CONFIG_DIR . '/' . SYL_CONFIG_COMPONENTS_FILE
        );
        // ٥ȼ¹
        $this->raiseEvent('initStream', $config_file);
    }

    /**
     * ¹
     *
     * @access protected
     */
    function loadStream()
    {
        // Хե륿ե
        $global_filters_file = SYL_CONFIG_DIR . '/' . SYL_CONFIG_FILTERS_FILE;
        // ץꥱե륿ե
        $app_filters_file = SYL_APP_DIR . '/' . SYL_CONFIG_FILTERS_FILE;

        $config_file = array();
        $config_file['filters'] = $global_filters_file . PATH_SEPARATOR . $app_filters_file;

        // ٥ȼ¹
        $this->raiseEvent('loadStream', $config_file);
    }

    /**
     * ¹
     *
     * @access protected
     */
    function executeStream()
    {
        // ¹Ƚ
        $config_file = array();
        if ($this->isExecuteAction()) {
            // ե
            $app_actions_file = SYL_APP_DIR . '/' . SYL_CONFIG_ACTIONS_FILE;
            $config_file['actions'] = $app_actions_file;
        }

        // ٥ȼ¹
        $this->raiseEvent('executeStream', $config_file);
    }

    /**
     * ӥ塼ɽ¹
     *
     * @access protected
     */
    function middleStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('middleStream');
    }

    /**
     * ӥ塼ɽ
     *
     * @access protected
     */
    function renderStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('renderStream');
    }

    /**
     * ӥ塼ɽ¹Ը
     *
     * @access protected
     */
    function unloadStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('unloadStream');
    }

    /**
     * ǽ
     * register_shutdown_function
     *
     * @access protected
     */
    function finalStream()
    {
        // ¹ԥ
        if (is_object($this->container)) {
            // ٥ȼ¹
            $this->raiseEvent('finalStream');
        }

        // ݡͥȤȤϿ줿destory᥽åɼ¹
        $cnt = count($this->destory_objects);
        for ($i=0; $i<$cnt; $i++) {
          call_user_func($this->destory_objects[$i]);
        }
    }

    /**
     * ȥݥ
     *
     * @access public
     */
    function stream()
    {
        // 
        $this->initStream();
        // ¹
        $this->loadStream();
        // ¹Խ
        $this->executeStream();
        // ӥ塼ɽ¹
        $this->middleStream();
        // ӥ塼ɽ¹
        $this->renderStream();
        // ӥ塼ɽ¹Ը
        $this->unloadStream();
/*
echo "<pre>";
print_r($this->container->components);
echo "</pre>";

*/

    }

    /**
     * ٥ȼ¹
     *
     * @access private
     * @param string ٥ȥ᥽å̾
     * @param string ե̾
     */
    function raiseEvent($event, $config_type=array())
    {
        $this->container->raiseEvent($event, $config_type);
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ
     */
    function getActionDir()
    {
        return $this->action_dir;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     *
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->template_dir;
    }

    /**
     * ¹Ƚ򥻥å
     * 
     * @access public
     * @return bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function setExecuteAction($is_execute_action)
    {
        $this->is_execute_action = ($is_execute_action !== false);
    }

    /**
     * ¹Ƚ
     * 
     * @access public
     * @return bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function isExecuteAction()
    {
        return $this->is_execute_action;
    }
}

?>
