<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DefinesReader.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Config.php';

/**
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DefinesReader.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DefinesReader
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     * @param object ȥ饪֥
     */
    function readConfig(&$controller)
    {
        // ץꥱͤɤ߹
        $config_file = SYL_WEBAPP_DIR . DIRECTORY_SEPARATOR . $controller->app_name . DIRECTORY_SEPARATOR . SYL_CONFIG_DEFINE_FILE;
        SyL_DefinesReader::_readConfig($config_file, $controller);
        // Хͤɤ߹
        $config_file = SYL_CONFIG_DIR . DIRECTORY_SEPARATOR . SYL_CONFIG_DEFINE_FILE;
        SyL_DefinesReader::_readConfig($config_file, $controller);
    }

    /**
     * ɤ߹
     *
     * @access private
     * @param string ե̾
     * @param object ȥ饪֥
     */
    function _readConfig($config_file, &$controller)
    {
        if (is_file($config_file)) {
            $config =& SyL_Config::getObject('defines', $config_file, $controller);
            $config->parseXML();
        }
    }
}

?>
