<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSmtp.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * å³饹
 */
require_once dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'SyL_Socket.php';

/**
 * ᡼륵СΥۥ̾
 */
define('SYL_MAIL_SERVER_HOST', '');
/**
 * ᡼륵СΥݡֹ
 */
define('SYL_MAIL_SERVER_PORT', 25);

/**
 * SMTP᡼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSmtp.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailSmtp extends SyL_Mail
{
    /**
     * ᡼륵СΥۥ̾
     *
     * @access private
     * @var string
     */
    var $host = SYL_MAIL_SERVER_HOST;
    /**
     * ᡼륵СΥݡ
     *
     * @access private
     * @var int
     */
    var $port = SYL_MAIL_SERVER_PORT;
    /**
     * åȥ饹
     *
     * @access private
     * @var object
     */
    var $socket = null;

    /**
     * 󥹥ȥ饯
     *
     * @access private
     */
    function SyL_MailSmtp()
    {
        parent::SyL_Mail();
    }

    /**
     * ۥȤ򥻥å
     * 
     * @access public
     * @param string ۥ̾
     */
    function setHost($host)
    {
        $this->host = $host;
    }

    /**
     * ݡֹ򥻥å
     * 
     * @access public
     * @param int ݡֹ
     */
    function setPort($port)
    {
        $this->port = $port;
    }

    /**
     * ᡼
     *
     * @access public
     * @param array ᡼°
     * @param bool ե饰
     * @return OK: true, NG: false
     */
    function init($attributes=array(), $all=false)
    {
        $attributes = array_change_key_case($attributes, CASE_LOWER);
        parent::init($attributes, $all);

        if ($all) {
            // ۥȥå
            if (isset($attributes['host'])) {
                $this->host = $attributes['host'];
            }
            // ݡȥå
            if (isset($attributes['port'])) {
                $this->port = $attributes['port'];
            }

            // åȥ֥Ⱥ
            $this->socket = new SyL_Socket($this->host, $this->port);
            $this->socket->setDebugCallBackFunc(array(&$this, 'receiveMessage'));

            if (!$this->socket->open()) {
                $this->error_message = $this->socket->getLastError();
                return false;
            } else {
                // ³å
                $this->socket->receive();
                // å
                $this->socket->send('HELO ' . $this->host);
                // å
                $this->socket->receive();
            }
        }
        return true;
    }

    /**
     * ᡼¹
     *
     * @access public
     * @return OK: true, NG: false
     */
    function send()
    {
        if (!parent::send()) {
            return false;
        }

        // åȺȽ
        if (!is_object($this->socket) || !$this->socket->isSocket()) {
            $this->error_message = "[SyL error] Socket not created";
            return false;
        }

        // ޥȯ ------------------------------------------------------------

        // åȥå
        $this->socket->send('MAIL FROM: ' . $this->headers['MAIL_FROM']);
        // åȥå
        $this->socket->receive();

        foreach ($this->headers['RCPT_TO'] as $to) {
            // 襻åȥå
            $this->socket->send('RCPT TO: ' . $to);
            // 襻åȥå
            $this->socket->receive();
        }

        if ($this->isError()) {
            return false;
        }

        // ᡼إå ----------------------------------------------------------

        // ǡåȥå
        $this->socket->send('DATA');
        // ǡåȥå
        $this->socket->receive();

        // ᡼إåޤʸ
        // .פϥ
        $data = $this->getHeaderMessage(preg_replace('/(\r\n|\n|\r)\.(\r\n|\n|\r)/s', '$1..$2', $this->body));
        // Ǹˡ.פղ
        $data .= '.';

        if ($this->isError()) {
            return false;
        }

        // -------------------------------------------------------------------------

        // ǡåȥå
        $this->socket->send($data);
        // ǡåȥå
        $this->socket->receive();

        if ($this->isError()) {
            return false;
        }

        // ꥻåȥå
        $this->socket->send('RSET');
        // ꥻåȥå
        $this->socket->receive();

        if ($this->isError()) {
            return false;
        }

        // 
        $this->init();

        return true;
    }

    /**
     * ᡼륵СȤ³Ĥ
     *
     * @access public
     */
    function quit()
    {
        if (is_object($this->socket) && $this->socket->isSocket()) {
            // λå
            $this->socket->send('QUIT');
            // λå
            $this->socket->receive();
            // åȤĤ
            $this->socket->close();
        }
    }

    /**
     * å
     *
     * @access private
     * @param string ޥɥå
     */
    function receiveMessage($type, $message)
    {
        if ($type == 'receive') {
            if (preg_match('/^[4|5][0-9]{2}/', $message)) {
                $this->error_message = "[SyL error] SMTP command error ($message)";
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}

?>
