<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidatorFiles.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륢åץɸڥ饹
 * 
 * 
 * $SyL_Validator =& SyL_Validator::create( 'files', '{name}ɬܤǤ' );
 *
 * 顼åѴʸ
 *  ʤ
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidatorFiles.php,v 1.2 2006/12/06 13:04:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidatorFiles extends SyL_Validator
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string 顼åΥեޥå
     * @param array ڥѥ᡼
     */
    function SyL_ValidatorFiles($error_message, $parameters=array())
    {
        // ǥեȥѥ᡼
        $init_parameters = array(
          'name_format'          => null,
          'name_format_error'    => null,
          'min_size'             => 1, // 
          'min_size_error'       => null,
          'max_size'             => null, // checkbox, select, fileκå
          'max_size_error'       => null,
          'mime_format'          => null, // mime typeɽǸ
          'mime_format_error'    => null,
          'is_upload_func'       => null, // is_uploaded_fileؿǸ
          'is_upload_func_error' => null
        );
        $parameters = array_merge($init_parameters, $parameters);
        parent::SyL_Validator($error_message, $parameters);
    }

    /**
     * ɬܸڽ¹Ԥ
     *
     * @access public
     * @param array о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        sort($value['size'], SORT_NUMERIC);
        // Ǿͥå
        if ($this->parameters['min_size'] !== null) {
            if ($value['size'][0] < $this->parameters['min']) {
                if ($this->parameters['min_size_error'] !== null) {
                    $this->error_message = $this->parameters['min_size_error'];
                }
                return false;
            }
        }
        // ͥå
        if ($this->parameters['max_size'] !== null) {
            if ($value['size'][count($value['size'])-1] > $this->parameters['max']) {
                if ($this->parameters['max_size_error'] !== null) {
                    $this->error_message = $this->parameters['max_size_error'];
                }
                return false;
            }
        }
        // ե̾å
        if ($this->parameters['name_format'] !== null) {
            foreach ($value['name'] as $tmp) {
                if (!preg_match($this->parameters['name_format'], $tmp)) {
                    if ($this->parameters['name_format_error'] !== null) {
                        $this->error_message = $this->parameters['name_format_error'];
                    }
                    return false;
                }
            }
        }
        // MIMEץå
        if ($this->parameters['mime_format'] !== null) {
            foreach ($value['type'] as $tmp) {
                if (!preg_match($this->parameters['mime_format'], $tmp)) {
                    if ($this->parameters['mime_format_error'] !== null) {
                        $this->error_message = $this->parameters['mime_format_error'];
                    }
                    return false;
                }
            }
        }
        // POSTå
        if ($this->parameters['is_upload_func'] !== null) {
            foreach ($value['tmp_name'] as $tmp) {
                if (!is_uploaded_file($tmp)) {
                    if ($this->parameters['is_upload_func_error'] !== null) {
                        $this->error_message = $this->parameters['is_upload_func_error'];
                    }
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * 顼å
     * С饤
     *
     * @access public
     * @param string ̾
     * @return string 顼å
     */
    function getErrorMessage($name='')
    {
        if ($this->parameters['min_size'] !== null) {
            $this->error_message = str_replace('{min_size}', $this->parameters['min_size'], $this->error_message);
        }
        if ($this->parameters['max_size'] !== null) {
            $this->error_message = str_replace('{max_size}', $this->parameters['max_size'], $this->error_message);
        }
        return parent::getErrorMessage($name);
    }

    /**
     * ɬܸڽJavaScript
     *
     * @access public
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScript($display_name, $parts)
    {
        $js  = '';
        if ($this->parameters['name_format'] !== null) {
            $js .= 'if (!error_flag && !validator.isRegex(element_name, "' . $this->getErrorMessage($display_name) . '", ' . $this->parameters['name_format'] . ')) {' . "\r\n";
            $js .= '  error_flag = true;' . "\r\n";
            $js .= '}' . "\r\n";
        }
        return $js;
    }

}

?>
