<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterExecutionTime.php,v 1.5 2006/12/16 19:09:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륿饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Filter.php';

/**
 * ַ¬ե륿饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterExecutionTime.php,v 1.5 2006/12/16 19:09:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 **/
class SyL_FilterExecutionTime extends SyL_Filter
{
    /**
     * ¬ϻֳǼ
     * 
     * @param float
     */
    var $timer_start = 0;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_FilterExecutionTime()
    {
        $this->timer_start = $this->getNowMicroTime();
    }

    /**
     * 쥯ȼ᥽å
     *
     * @access public
     * @param object ꥯȥ֥
     * @param object ӥ塼ǡ֥
     */
    function trigger()
    {
        return $this->getExecutionTime();
    }

    /**
     * ӥ塼ɽե륿
     *
     * @access public
     * @param object ꥯȥ֥
     * @param object ӥ塼ǡ֥
     */
    function renderAfter()
    {
        $result = $this->getExecutionTime();
        $memory = -1;
        if (function_exists('memory_get_usage')) {
            $memory = memory_get_usage();
            if ($memory > 0) {
                $memory = round($memory/1024, 3);
            }
        }
        if ($memory >= 0) {
            echo "<br>[Execution: {$result}(s) Memory: {$memory}(KB)]<br>";
        } else {
            echo "<br>[Execution: {$result}(s)]<br>";
        }
    }

    /**
     * ߻֤
     *
     * list( $usec, $sec ) = explode( ' ', microtime() );
     *  $sec  = 1142084005 // UNIX timestamp
     *  $usec = 0.95226600
     *
     * @access public
     * @return float UNIXॹפޥäޤ
     */
    function getNowMicroTime()
    {
        list($usec, $sec) = explode(' ', microtime());
        return ((float)$sec + (float)$usec); 
    }

    /**
     * ¹Ի֤
     *
     * @access public
     * @return int ¹Ի֤msޤ
     */
    function getExecutionTime()
    {
        $execution_time = $this->getNowMicroTime() - $this->timer_start;
        if ($execution_time > 0) {
            $execution_time = sprintf("%01.3f", round($execution_time, 3));
        }
        return $execution_time;
    }
}

?>
