<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterPathinfo.php,v 1.3 2006/12/16 19:08:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * PATH_INFOĶѿե졼ͤ륯饹
 *
 * +++ 
 * ե̾
 * 󥯥饹̾
 * ̾
 * ƥץ졼ȥե̾
 *
 * +++ 
 *   /dir/app1.php/hoge1/hoge2/cmd.html
 * 
 * [ե̾]
 *   /hoge1/hoge2/app1.php
 *   1) .../app1.php/test2_2/test.html => /test2_2/app1.php
 *   2) .../app1.php/test.html => /app1.php
 *   3) .../app1.php/ => /ʥǥեȥ̾
 * [󥯥饹̾]
 *   Hoge1_Hoge2_App1
 * [̾]
 *   cmd
 *   1) .../app1.php/test2_2/cmd => cmd
 *   2) .../app1.php/ => ̵
 * [ƥץ졼ȥե̾]
 *   /hoge1/hoge2/app1.html
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterPathinfo.php,v 1.3 2006/12/16 19:08:27 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RouterPathinfo extends SyL_Router
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RouterPathinfo(&$request)
    {
        // ١ץȼ
        $script_name = basename($_SERVER['SCRIPT_NAME']);
        // PATH_INFOĶѿ
        $pathinfo = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';

        // ѥå
        if ($this->isInvalidPath($pathinfo)) {
            SyL_Router::redirect404();
        }

        if ($pathinfo == '') {
            $this->action_name = '';
            $this->action_file = '/' . $script_name;
        } else if (substr($pathinfo, -1) == '/') {
            $this->action_name = '';
            $this->action_file = $pathinfo . $script_name;
        } else {
            $pathinfo_dir = dirname($pathinfo);
            if ($pathinfo_dir == '/') {
                $this->action_file = DIRECTORY_SEPARATOR . $script_name;
            } else {
                $this->action_file = $pathinfo_dir . DIRECTORY_SEPARATOR . $script_name;
            }
            if ($this->ext) {
                if (preg_match( '/^(.*)\/(.+)(' . preg_quote($this->url_ext) . ')$/', $pathinfo, $matches)) {
                    $this->action_name = $matches[2];
                } else {
                    SyL_Router::redirect404();
                }
            } else {
                $this->action_name = basename($pathinfo);
            }
        }

        // ֤
        if ($request->isParameter(SYL_ACTION_KEY)) {
            $this->action_name = $request->getParameter(SYL_ACTION_KEY);
        }

        // PATH_INFO
        $this->pathinfo = explode('/', $pathinfo);
        array_shift($this->pathinfo);
        if (count($this->pathinfo) > 0) {
            array_pop($this->pathinfo);
        }

        // 饹ե
        if ($this->action_file != '') {
            $classname = implode( '_', array_map('ucfirst', $this->pathinfo) );
            if ($classname != '') {
                $classname = $classname . '_' . ucfirst(basename($script_name,$this->exe_ext));
            } else {
                $classname = ucfirst(basename($script_name,$this->exe_ext));
            }
            $this->class_name = $classname;
        }

        // URL
        $syl_self = $_SERVER['PHP_SELF'];
        if ($pathinfo == '') {
            $syl_self = $syl_self . '/';
        } else if (substr($pathinfo, -1) == '/') {
            $syl_self = $syl_self;
        } else {
            $syl_self = dirname($syl_self) . '/';
        }
        $this->setSyLSelf($syl_self);

/*
echo "script_name: " . $script_name . "<br>";
echo "pathinfo: " . $pathinfo . "<br>";
echo "action_name: " . $this->action_name . "<br>";
echo "action_file: " . $this->action_file . "<br>";
echo "class_name: " . $this->class_name . "<br>";
echo "<pre>";
print_r($this->pathinfo);
echo "</pre>";
exit;
*/


    }

}

?>
