<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LocationManager.php,v 1.5 2006/12/16 19:07:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܴ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LocationManager.php,v 1.5 2006/12/16 19:07:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_LocationManager
{
    /**
     * ̾
     * 
     * @access private
     * @var string
     */
    var $action_name = '';
    /**
     * ǥ쥯ȥ
     * 
     * @access private
     * @var string
     */
    var $action_dir = '';
    /**
     * ե
     * 
     * @access private
     * @var string
     */
    var $action_file = '';
    /**
     * 󥯥饹
     * 
     * @access private
     * @var string
     */
    var $action_class = '';
    /**
     * ƥץ졼ȥ
     * 
     * @access private
     * @var string
     */
    var $template_type = '';
    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access private
     * @var string
     */
    var $template_dir = '';
    /**
     * ƥץ졼ȥե
     * 
     * @access private
     * @var string
     */
    var $template_file = '';
    /**
     * ޥӥ塼ե
     * 
     * @access private
     * @var string
     */
    var $customized_view_file = '';
    /**
     * ޥӥ塼饹̾
     * 
     * @access private
     * @var string
     */
    var $customized_view_class = '';
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * ꥯȥ֥
     * 
     * @access private
     * @var object
     */
    var $requests = null;
    /**
     * 󥪥֥
     * 
     * @access private
     * @var object
     */
    var $action = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ饪֥
     * @param object ܾ󥪥֥
     */
    function SyL_LocationManager(&$controller, &$router)
    {
        // ̾
        $this->action_name = $router->getActionName();
        // ǥ쥯ȥ
        $this->action_dir = $controller->getActionDir();
        // ե
        $this->action_file = $router->getActionFile();
        // 󥯥饹̾
        $this->action_class = $router->getClassName();
        // ǥեȥƥץ졼ȥǥ쥯ȥ
        $this->template_dir = $controller->getTemplateDir();
        // ȥ򥻥å
        $this->controller =& $controller;
    }

    /**
     * ꥯȥ֥Ȥ򥻥å
     * 
     * @access public
     * @param object ꥯȥ֥
     */
    function setRequests(&$requests)
    {
        $this->requests =& $requests;
    }

    /**
     * ¹Ƚ򥻥å
     * 
     * @access public
     * @return bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function setExecuteAction($is_execute_action)
    {
        $this->controller->setExecuteAction($is_execute_action);
    }

    /**
     * 󥪥֥Ȥ򥻥å
     * 
     * @access public
     */
    function setAction()
    {
        if ($this->controller->container->isComponent(SYL_ACTION_KEY)) {
            $this->action =& $this->controller->container->getComponent(SYL_ACTION_KEY);
        }
    }

    /**
     * 󥪥֥Ȥ¸Ƚ
     * 
     * @access public
     * @return bool true: 󥪥֥Ȥꡢfalse: 󥪥̵֥
     */
    function isAction()
    {
        return is_object($this->action);
    }

    /**
     * ƥץ졼ȥפ򥻥åȥ
     * 
     * @access public
     * @param string ƥץ졼
     */
    function setTemplateType($template_type)
    {
        $this->template_type = $template_type;
    }

    /**
     * ƥץ졼ȥפ
     * 
     * @access public
     * @return string ƥץ졼ȥ
     */
    function getTemplateType()
    {
        return $this->template_type;
    }

    /**
     * ƥץ졼ȥե򥻥å
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->convertPath($this->template_dir, true);
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        $template_dir  = $this->getTemplateDir();
        $template_file = $this->convertPath($this->template_file, false);
        $real_path     = realpath($template_dir . $template_file);
        $reg           = '/^' . preg_quote($template_dir, '/') . '/';
        // ե¸ߥå
        if (!$real_path || !preg_match($reg, $real_path)) {
            SyL_Router::redirect404();
        }
        return $template_file;
    }

    /**
     * ޥӥ塼å
     * 
     * @access public
     * @param string ޥӥ塼ե
     * @param string ޥӥ塼饹
     */
    function setCustomizedView($customized_view_file, $customized_view_class)
    {
        $this->customized_view_file  = $customized_view_file;
        $this->customized_view_class = $customized_view_class;
    }

    /**
     * ޥӥ塼ե
     * 
     * @access public
     * @return string ޥӥ塼ե
     */
    function getCustomizedViewFile()
    {
        return $this->convertPath($this->customized_view_file, false);
    }

    /**
     * ޥӥ塼饹
     * 
     * @access public
     * @return string ޥӥ塼饹
     */
    function getCustomizedViewClass()
    {
        return $this->customized_view_class;
    }

    /**
     * ѥ
     * 
     * @access public
     * @param string ѥ
     * @return string ѥ
     */
    function convertPath($path, $is_dir_path=false)
    {
        if ($is_dir_path && !preg_match('/(\\\\|\/)$/', $path)) {
            $path = $path . '/';
        } else if (!$is_dir_path && preg_match('/^(\\\\|\/)/', $path)) {
            $path = substr($path, 1);
        }
        return $path;
    }

    /**
     * ӥ塼Ϥѥ᡼
     * 
     * @access public
     * @return array ӥ塼Ϥѥ᡼
     */
    function &getValues()
    {
        $values = array();
        // ꥯȥѥ᡼
        if (SYL_TEMPLATE_REQUEST_DATA) {
            $obj    =& $this->requests->getParameterObject();
            $values += $obj->getParameterAll();
        }
        // åͤ
        if (SYL_TEMPLATE_SESSION_DATA) {
            $obj    =& $this->requests->getSessionObject();
            $values += $obj->getParameterAll();
        }
        // åͤ
        if (SYL_TEMPLATE_COOKIE_DATA) {
            $obj    =& $this->requests->getCookieObject();
            $values += $obj->getParameterAll();
        }

        // ѥ᡼
        if ($this->isAction()) {
            // 󥪥֥Ȥ¸ߤʥ¹ԸˤʤС
            // ץѥƥ
            foreach ($this->action as $key => $value) {
                if (substr($key, 0, 1) != '_') {
                    if (is_object($value)) {
                        $values[$key] =& $value;
                    } else {
                        $values[$key] = $value;
                    }
                }
            }
        } else {
            // 󥪥֥Ȥ¸ߤʤʥ¹̵ˤʤС
            // Υ饹ǥեȥץѥƥ
            if (!$this->controller->isExecuteAction()) {
                if (is_file($this->action_dir . $this->action_file)) {
                    include_once($this->action_dir . $this->action_file);
                    if (class_exists($this->action_class)) {
                        foreach (get_class_vars($this->action_class) as $key => $value) {
                            $values[$key] = $value;
                        }
                    }
                }
            }
        }

        return $values;
    }
}

?>
