<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Request.php,v 1.5 2006/12/16 19:07:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * p[^ێNX
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Request.php,v 1.5 2006/12/16 19:07:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Request
{
    /**
     * p[^z
     * 
     * @access protected
     */
    var $parameters = array();

    /**
     * p[^ݔ
     * 
     * @access public
     * @param string p[^
     * @return ݂: true, ݂Ȃ: false
     */
    function isParameter($name)
    {
        $arg_list = func_get_args();
        return (call_user_func_array(array(&$this, 'getParameterRecursive'), $arg_list) !== null);
    }

    /**
     * p[^Zbg
     * 
     * @access public
     * @param string p[^
     * @param string p[^l
     */
    function setParameter($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * p[^擾
     * 
     * @access public
     * @param string p[^
     * @return mixed p[^l
     */
    function getParameter($name)
    {
        $arg_list = func_get_args();
        return call_user_func_array(array(&$this, 'getParameterRecursive'), $arg_list);
    }


    /**
     * Sp[^擾
     * 
     * @access public
     * @return array Sp[^
     */
    function &getParameterAll()
    {
        return $this->parameters;
    }

    /**
     * p[^폜
     * 
     * @access public
     * @param string p[^
     */
    function deleteParameter($name)
    {
        if (isset($this->parameters[$name])) {
            unset( $this->parameters[$name] );
        }
    }

    /**
     * Sp[^폜
     * 
     * @access public
     */
    function deleteParameterAll()
    {
        $this->parameters = array();
    }

    /**
     * p[^ċA擾
     * 
     * @access public
     * @param string p[^
     * @return mixed p[^l
     */
    function getParameterRecursive($parameter_name)
    {
        static $value = null;
        $arg_list = func_get_args();

        if ($value === null) {
            $name = array_shift($arg_list);
            if (isset($this->parameters[$name])) {
                $value = $this->parameters[$name];
            } else {
                return null;
            }
        }

        if (count($arg_list) > 0) {
            $name = array_shift($arg_list);
            if (isset($value[$name])) {
                $value = $value[$name];
                return call_user_func_array(array(&$this, 'getParameterRecursive'), $arg_list);
            } else {
                return null;
            }
        } else {
            $return_value = $value;
            $value = null;
            return $return_value;
        }
    }

    /**
     * Sp[^Ɏw֐Kp
     * 
     * @access private
     * @param array p[^z
     * @param string ֐
     */
    function applyParameters($func)
    {
        $func_parameters = func_get_args();
        $this->applyParametersRecursive($this->parameters, $func_parameters);
    }

    /**
     * Sp[^Ɏw֐Kp
     * 
     * @access private
     * @param array p[^z
     * @param string ֐
     */
    function applyParametersRecursive(&$parameters, $args)
    {
        if (is_array($parameters)) {
            foreach($parameters as $key => $value) {
                $this->applyParametersRecursive($parameters[$key], $args);
            }
        } else {
            // Ƃ肠A^̂ݓKp
            if (is_string($parameters)) {
                $func_name = array_shift($args);
                $parameters = call_user_func_array($func_name, array_merge((array)$parameters, $args));
            }
        }
    }

}

?>
