<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Odbc.php,v 1.1 2006/12/16 19:07:28 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹ODBC
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB_Odbc.php,v 1.1 2006/12/16 19:07:28 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DB_Odbc extends SyL_DB
{
    /**
     * ³륿
     *
     * @access private
     * @var int
     */
    var $cursor_type = SQL_CUR_USE_ODBC;

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $this->connection = ($persistent) ? odbc_pconnect($dbname, $user, $passwd, $this->cursor_type)
                                          : odbc_connect ($dbname, $user, $passwd, $this->cursor_type);
        return is_resource($this->connection);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            odbc_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function getLastError()
    {
        $error_code = odbc_error($this->connection);
        $error_message = '';
        if ($error_code) {
            $error_message = "[Error Code {$error_code}]" . odbc_errormsg($this->connection);
        }
        return $error_message;
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function begin()
    {
        parent::begin();
        odbc_autocommit($this->connection, false);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollback()
    {
        odbc_rollback($this->connection);
        parent::rollback();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        odbc_commit($this->connection);
        parent::commit();
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function executeSelect($sql)
    {
        $result = @odbc_exec($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function executeUpdate($sql)
    {
        // ¹Ի顼Ƚ
        $result = @odbc_exec($this->connection, $sql);
        $num = odbc_num_rows($result);
        if ($num != -1) {
            return $num;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeNoReturn($sql)
    {
        // ¹Ի顼Ƚ
        $result = @odbc_exec($this->connection, $sql);
        if ($result !== false) {
            return true;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }
  
    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function executeGet($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execute($sql, $query);
  
        // ¹Ի顼Ƚ
        if (is_resource($query)) {
            switch ($get) {
            // 1ե
            case 'one':
                if (odbc_fetch_row($query)) {
                    $data = odbc_result($query, 1);
                } else {
                    $data = '';
                }
                break;
            // 1쥳
            case 'record':
                $data = array();
                if (odbc_fetch_row($query)) {
                    $cols = odbc_num_fields($query);
                    for ($i=1; $i<=$cols; $i++) {
                        $data[odbc_field_name($query, $i)] = odbc_result($query, $i);
                    }
                    $data = $this->changeFieldName($data);
                }
                break;
            // 쥳
            case 'all':
                $data = array();
                $cols = odbc_num_fields($query);
                while (odbc_fetch_row($query)) {
                    $tmp = array();
                    for ($i=1; $i<=$cols; $i++) {
                        $tmp[odbc_field_name($query, $i)] = odbc_result($query, $i);
                    }
                    $data[] = $this->changeFieldName($tmp);
                }
                break;
            }
            odbc_free_result($query);
            return true;
        } else {
            $this->executeTriggerError($this->getLastError());
            return false;
        }
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     * ¹ˡinitializePageץ᥽åɼ¹ɬ
     * SQLʸΡFROM׶ľ˥ʸɬܡʤʳΥʸԲġ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function executePage($sql, &$result, &$page_control, $limit, $page=1)
    {
/*
        // ڡ楯饹
        include_once dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'SyL_Pager.php';
        $page_control = new SyL_Pager();
        $page_control->setCount($limit);
        $page_control->setPage($page);

        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->executeGet($sql_count, $record, 'one')) return false;
        $page_control->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= " LIMIT "  . $page_control->getCount();
        $sql_page .= " OFFSET " . $page_control->getStartRecord();

        // ǡSQL¹
        return $this->executeGet($sql_page, $result, 'all');
*/
    }
}

?>
