<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Socket.php,v 1.5 2006/12/16 19:07:28 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

define('SYL_DEBUG', false);

/**
 *  åȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Socket.php,v 1.5 2006/12/16 19:07:28 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Socket
{
    /**
     * ³оݥС
     * 
     * @access private
     * @var string
     */
    var $host;
    /**
     * СΥݡ
     * 
     * @access private
     * @var int
     */
    var $port;
    /**
     * С쥹ݥ󥹥ǡ
     * 
     * @access private
     * @var string
     */
    var $response = '';
  
    /**
     * 顼No
     * 
     * @access private
     * @var int
     */
    var $error_no = 0;
    /**
     * 顼å
     * 
     * @access private
     * @var int
     */
    var $error_string = '';
    /**
     * åȥͥ
     * 
     * @access private
     * @var resource
     */
    var $conn = null;
    /**
     * ǥХåʸ᥽å
     * 
     * @access private
     * @var mixed
     */
    var $debug_callback_func = null;

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string ³оݥС
     * @param int ³оݥСΥݡ
     */
    function SyL_Socket($host, $port)
    {
        $this->host = $host;
        $this->port = $port;
    }

    /**
     * ǥХåʸ᥽åɤ򥻥å
     * 
     * @access public
     * @param mixed ǥХåʸ᥽å
     */
    function setDebugCallBackFunc($debug_callback_func)
    {
        $this->debug_callback_func =& $debug_callback_func;
    }

    /**
     * ǥХåʸ᥽åɼ¹
     * 
     * @access public
     * @param string send or receive
     * @param string åʸ
     */
    function trace($type, $message)
    {
        if ($this->debug_callback_func != null) {
            call_user_func($this->debug_callback_func, $type, $message);
        }
    }

    /**
     * 顼Ƚꤹ
     * 
     * @access public
     * @return bool true: false: 顼
     */
    function isError()
    {
        return ($this->error_no != 0);
    }

    /**
     * 顼Noȥ顼å
     * 
     * @access public
     * @return array 顼Noȥ顼åޤ
     */
    function getLastError()
    {
        return (($this->error_no != 0) ? "[SyL error] Socket error: No.{$this->error_no} {$this->error_string}" : null);
    }

    /**
     * åȤ򳫤
     * 
     * @access public
     * @param int ॢ
     * @return true: ³OK, false: ³NG
     */
    function open($timeout=3)
    {
        $this->conn = fsockopen($this->host, $this->port, $this->error_no, $this->error_string, $timeout);
        if (!$this->isSocket()) {
            return false;
        }
        // ॢ
        if (!stream_set_timeout($this->conn, $timeout)) {
            $this->error_no = 1;
            $this->error_string = "stream_set_timeout setting error";
            return false;
        }
        // ֥å󥰥⡼
        if (!stream_set_blocking($this->conn, 1)) {
            $this->error_no = 1;
            $this->error_string = "stream_set_blocking setting error";
            return false;
        }

        return true;
    }

    /**
     * å³ǧ
     * 
     * @access public
     * @return true: OK, false: NG
     */
    function isSocket()
    {
        return is_resource($this->conn);
    }

    /**
     * åȤĤ
     * 
     * @access public
     * @return true: OK, false: NG
     */
    function close()
    {
        if ($this->isSocket()) {
            if (fclose($this->conn)) {
              return true;
            } else {
                $this->error_no = 1;
                $this->error_string = "fclose error";
                return false;
            }
        } else {
            $this->error_no = 1;
            $this->error_string = "close failed for socket is not resource";
            return false;
        }
    }

    /**
     * ޥɤ򥵡С
     * 
     * @access public
     *
     * @param string ޥ
     * @return boolean OK: true, NG: false
     */
    function send($request)
    {
        // ꥽γǧ
        if (!$this->isSocket()) return false;
        // ޥɤ
        fwrite($this->conn, $request . "\r\n");
        // 
        $this->trace('send', $request);
        return true;
    }

    /**
     * ̤̤˼
     * 
     * @access public
     * @param string ǡ
     * @return bool true: OK, false: 顼
     */
    function receive()
    {
        // ꥽γǧ
        if (!$this->isSocket()) return false;
        // ̤
        $receive = fgets($this->conn, 4096);
        // 
        $this->trace('receive', $receive);
        // ॢȽ
        if (!$this->isTimeout()) {
            return false;
        }
        return $receive;
    }

    /**
     * ̤Ƽ
     * 
     * @access public
     * @return string ǡ
     * @return bool true: OK, false: 顼
     */
    function receiveAll($eof=false)
    {
        // ̤
        $receive = '';
        if ($eof) {
            while (!feof($this->conn)) {
                $receive .= $this->receive();
            }
        } else {
            while (true) {
                $tmp = $this->receive();
                if ($tmp === false) {
                    break;
                }
                $receive .= $tmp;
            }
        }
        return $receive;
    }

    /**
     * ॢȽ
     * 
     * @access public
     * @return bool true: ॢ̵, false: ॢȥ顼
     */
    function isTimeout()
    {
        // ॢȽ
        $stream = stream_get_meta_data($this->conn);
        if (isset($stream['timeout']) && $stream['timeout']) {
            $this->error_no = 1;
            $this->error_string = "send timeout";
            return false;
        } else {
            return true;
        }
    }
}

?>
