<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.4 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܾ󥯥饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Forward.php';

/**
 * URLѥ᡼ե졼ͤ륯饹
 *
 * +++ 
 * ե̾
 * 󥯥饹̾
 * ̾
 * ƥץ졼ȥե̾
 *
 * +++ 
 *   /dir/app1.php?action=/hoge1/hoge2/test.cmd
 * 
 * [ե̾]
 *   /hoge1/hoge2/test.php
 *   1) .../app1.php/test2_2/test => /test2_2/test.php
 *   2) .../app1.php/test => /test.php
 *   3) .../app1.php/ => /ʥǥեȥ̾
 * [󥯥饹̾]
 *   Hoge1_Hoge2_Test
 * [̾]
 *   cmd
 *   1) .../app1.php/test2_2/test => ̵
 *   2) .../app1.php/ => ̵
 * [ƥץ졼ȥե̾]
 *   /hoge1/hoge2/test.html
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.4 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ForwardParameter extends SyL_Forward
{
    /**
     * ζڤʸ
     *
     * @access private
     * @var string
     */
    var $action_delimiter = SYL_FORWARD_ACTION_DELIMITER;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ForwardParameter(&$request)
    {
        // ѥǼѿ
        $pathinfo = $request->getParameter(SYL_ACTION_KEY);

        // ѥå
        if ($this->isInvalidPath($pathinfo)) {
            SyL_Forward::redirect404();
        }

        if ($pathinfo == '') {
            $this->action_name = '';
            $this->action_file = '/' . $this->action_file_default;
        } else if (substr($pathinfo, -1) == '/') {
            $this->action_name = '';
            $this->action_file = $pathinfo . $this->action_file_default;
        } else {
            // ĥȽ
            if ($this->ext && !preg_match('/^(.+)(' . preg_quote($this->url_ext) . ')$/', $pathinfo)) {
                SyL_Forward::redirect404();
            }
            $pathinfo_file  = basename($pathinfo);
            $pathinfo_dir   = dirname($pathinfo);
            $pathinfo_files = explode($this->action_delimiter, $pathinfo_file, 2);
            if ($pathinfo_dir != '/') {
                $pathinfo_dir = $pathinfo_dir . DIRECTORY_SEPARATOR;
            }
            if (count($pathinfo_files) == 2) {
                // 󤢤
                $this->action_name = $pathinfo_files[1];
                $this->action_file = $pathinfo_dir . $pathinfo_files[0] . $this->exe_ext;
            } else {
                // ʤ
                $this->action_name = '';
                $this->action_file = $pathinfo_dir . $pathinfo_files[0] . $this->exe_ext;
            }
        }

        // PATH_INFO
        $this->pathinfo = explode('/', $pathinfo);
        array_shift($this->pathinfo);
        if (count($this->pathinfo) > 0) {
            array_pop($this->pathinfo);
        }

        // 饹ե
        if ($this->action_file != '') {
            $classname = implode('_', array_map('ucfirst', $this->pathinfo));
            if ($classname != '') {
                $this->class_name = $classname . '_' . ucfirst(basename($this->action_file, $this->exe_ext));
            } else {
                $this->class_name = ucfirst(basename($this->action_file,$this->exe_ext));
            }
        }

        // URL
        $syl_self = $_SERVER['PHP_SELF'];
        if ($pathinfo == '') {
            $syl_self = $syl_self . '/';
        } else if (substr($pathinfo, -1) == '/') {
            $syl_self = $syl_self;
        } else {
            $syl_self = dirname($syl_self) . '/';
        }
        $this->setSyLSelf($syl_self);

/*
echo "pathinfo: " . $pathinfo . "<br>";
echo "action_name: " . $this->action_name . "<br>";
echo "action_file: " . $this->action_file . "<br>";
echo "class_name: " . $this->class_name . "<br>";
echo "syl_self: " . $this->syl_self . "<br>";
echo "<pre>";
print_r($this->pathinfo);
echo "</pre>";
exit;
*/

    }

}

?>
