<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ComponentMethod.php,v 1.2 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݡͥȥ᥽åɥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ComponentMethod.php,v 1.2 2006/12/19 13:27:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ComponentMethod
{
    /**
     * 쥯ȼ᥽å̾
     * 
     * @access private
     * @var string
     */
    var $direct_method = 'trigger';
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * ץꥱ󥳥ݡͥ̾Ȥκǽ¹ԥ᥽å
     * 
     * @access private
     * @var array
     */
    var $app_components = array();

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_ComponentMethod(&$controller)
    {
        $this->controller =& $controller;
    }

    /**
     * ե륿ͤ
     * 
     * @access public
     * @param string ե륿̾
     * @return mixed ե륿
     */
    function triggerFilter($name)
    {
        $name = "__filter_{$name}";
        $component =& $this->_getComponent($name);
        $args = func_get_args();
        array_shift($args);
        return call_user_func_array(array(&$component, $this->direct_method), $args);
    }

    /**
     * ץꥱ󥳥ݡͥȤͤ
     * 
     * @access public
     * @param string ץꥱ󥳥ݡͥ̾
     * @return mixed ץꥱ󥳥ݡͥȤ
     */
    function triggerApp($name)
    {
        $component =& $this->_getComponent($name);
        $args = func_get_args();
        array_shift($args);
        return call_user_func_array(array(&$component, $this->direct_method), $args);
    }

    /**
     * ݡͥȤ
     * 
     * @access public
     * @param string ݡͥ̾
     * @return object ݡͥ
     */
    function &_getComponent($name)
    {
        if (!$this->controller->container->isComponent($name)) {
            trigger_error("[SyL error] Filter or AppComponent is not undefined (name: {$name})", E_USER_ERROR);
        }
        $component =& $this->controller->container->getComponent($name);
        if (!method_exists($component, $this->direct_method)) {
            trigger_error("[SyL error] Filter or AppComponent method is not undefined (name: {$this->direct_method})", E_USER_ERROR);
        }
        return $component;
    }

    /**
     * ץꥱ󥳥ݡͥȤ򥻥å
     * 
     * @access public
     * @param string ץꥱ󥳥ݡͥ̾
     * @param string ץꥱ󥳥ݡͥȺǽ᥽å̾
     * @param float ¹Խ
     */
    function addAppComponent($name, $method, $priority)
    {
        $name = "{$name}:{$method}";
        $this->app_components[$name] = $priority;
    }

    /**
     * ץꥱ󥳥ݡͥȤ˴
     * 
     * @access public
     */
    function deleteAppComponent()
    {
        // ץꥱ󥳥ݡͥȺ
        if (count($this->app_components) > 0) {
            // ¹ԽȤϵս˥
            arsort($this->app_components, SORT_NUMERIC);
            foreach ($this->app_components as $name => $method) {
                list($name, $method) = explode(':', $name, 2);
                if ($method != '') {
                   $component =& $this->controller->container->getComponent($name);
                   $component->{$method}();
                }
                $this->controller->container->deleteComponent($name);
            }
        }
    }
}

?>
