<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Form.php,v 1.6 2006/12/19 13:28:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

// åȽ
define( 'SYL_FORM_SESSION', false );
// JS顼åǥեȥإå
define( 'SYL_FORM_JS_ERROR_HEADER', 'ʲΥ顼ȯޤ\n\n' );
// JS顼åǥեȥեå
define( 'SYL_FORM_JS_ERROR_FOOTER', '' );
// JSץ
define( 'SYL_FORM_JS_SCRIPT', '/form/SyL_Validator.js' );

/**
 * ڸ̥饹δ쥯饹
 */
require_once 'SyL_FormElement.php';

/**
 * ե९饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Form.php,v 1.6 2006/12/19 13:28:24 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Form
{
    /**
     * ե°
     *
     * @access private
     * @var array
     */
    var $attributes = array();
    /**
     * եǤδܥ֥ȳǼ
     *
     * @access private
     * @var array
     */
    var $elements = array();
    /**
     * ɽ
     *
     * @access private
     * @var array
     */
    var $results = array();
    /**
     * åǽȽ
     *
     * @access private
     * @var bool
     */
    var $session = false;
    /**
     * JavaScriptϥåȽ
     *
     * @access private
     * @var bool
     */
    var $js = false;
    /**
     * JavaScriptϥåؿ̾
     *
     * @access private
     * @var string
     */
    var $js_func_name = 'SyLFormCheck';
    /**
     * JavaScript顼åΥإå
     *
     * @access private
     * @var string
     */
    var $js_error_header = SYL_FORM_JS_ERROR_HEADER;
    /**
     * JavaScript顼åΥեå
     *
     * @access private
     * @var string
     */
    var $js_error_footer = SYL_FORM_JS_ERROR_FOOTER;
    /**
     * JavaScript饤֥URL
     *
     * @access private
     * @var string
     */
    var $js_url = SYL_FORM_JS_SCRIPT;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string եHTML̾
     * @param string եɽ̾ʥåܥåξΤ
     * @param string եǤ
     * @param array եǤradio, select, checkboxξΤߡ
     * @param string եǤɲ°
     */
    function SyL_Form($form_name="syl_form", $action=null, $method='post')
    {
        // å󤬻ѲǽȽ
        if (SYL_FORM_SESSION) {
            if (!session_id()) {
                session_start();
            }
            if (isset($_SESSION['__SyL_Form__'])) {
                $this->session = true;
            } else {
                $_SESSION['__SyL_Form__'] = true;
            }
        }

        $this->attributes['name']   = $form_name;
        $this->attributes['method'] = $method;
        $this->attributes['action'] = ($action == null) ? $_SERVER["PHP_SELF"] : $action;

        // եॹơ
        $this->results['syl_form']       = '';
        $this->results['syl_javascript'] = '';
        $this->results['syl_read_only']  = false;
        $this->results['syl_error']      = false;
        // 顼å
        $this->results['syl_error_message'] = array();
    }

    /**
     * ̥եǥ֥Ȥμ
     *
     * @access public
     * @param string եǥ
     * @param string եHTML̾
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @param mixed եǤ͡checkboxξ󡢤ʳstring
     * @param string եǤɲ°
     */
    function &createElement($type, $element_name, $display_name, $parts=array(), $value=null, $attributes=array())
    {
        return SyL_FormElement::create($type, $element_name, $display_name, $parts, $value, $attributes);
    }

    /**
     * եǥ֥Ȥ򥻥å
     *
     * @access public
     * @param object եǥ֥
     */
    function addElement(&$element)
    {
        $name = $element->getName();
        $element->setFormName($this->attributes['name']);
        $element->setFormSession($this->session);
        // ǥ֥ȳǼ
        $this->elements[$name] =& $element;
        // 
        $this->results[$name] = array(
          'label'         => '',
          'html'          => '',
          'require'       => false,
          'error'         => false,
          'error_message' => '',
          'read_only'     => false
        );
      }

    /**
     * JavaScriptȽ
     *
     * @access public
     * @param bool JavaScriptȽ
     */
    function setJavaScript( $js )
    {
        $this->js = $js;
        $this->attributes['onSubmit'] = 'return ' . $this->js_func_name . '(this);';
    }

    /**
     * JavaScript顼åإåեå
     *
     * @access public
     * @param string JavaScript顼åإå
     * @param string JavaScript顼åեå
     */
    function setJavaScriptHeaderFooter($js_header, $js_footer)
    {
        $this->js_error_header = $js_header;
        $this->js_error_footer = $js_footer;
    }

    /**
     * ƤǤθڤ¹Ԥ
     *
     * @access public
     * @return true: 顼ʤfalse: 顼
     */
    function validate()
    {
        $result = true;
        foreach (array_keys($this->elements) as $key) {
            if (!$this->elements[$key]->validate()) {
                $name          = $this->elements[$key]->getName();
                $error_message = $this->elements[$key]->getErrorMessage();
                $this->results[$name]['error'] = true;
                $this->results[$name]['error_message'] = $error_message;
                $this->results['syl_error'] = true;
                $this->results['syl_error_message'][] = $error_message;
                $result = false;
            }
        }
        return $result;
    }

    /**
     * եɽ̾
     *
     * @access public
     * @param string ե̾
     * @return string եɽ̾
     */
    function getName($name)
    {
        return $this->elements[$name]->getDisplayName();
    }

    /**
     * եǤHTML
     *
     * @access public
     * @param string ե̾
     * @param bool true: html󥳡ɤԤfalse: html󥳡ɤԤʤ
     * @return string եǤHTML
     */
    function getHtml($name)
    {
        return $this->elements[$name]->getHtml();
    }

    /**
     * Ǥͤ
     *
     * @access public
     * @param string ե̾
     * @return mixed Ǥ
     */
    function getValue($name)
    {
        return $this->elements[$name]->getValue();
    }

    /**
     * ƤǤͤ
     *
     * @access public
     * @return array ƤǤ
     */
    function getValueAll()
    {
        $values = array();
        foreach (array_keys($this->elements) as $name) {
            $values[$name] = $this->getValue($name);
        }
        return $values;
    }

    /**
     * եǤɬܤȽꤹ
     *
     * @access public
     * @param string ե̾
     * @return bool true: ɬܡfalse: Ǥ
     */
    function isRequire($name)
    {
        if ($this->results['syl_read_only']) {
            // ɽϡǤվ֤Ȥ
            return false;
        } else {
            return $this->elements[$name]->isRequire();
        }
    }

    /**
     * եǤɽΤߤȽꤹ
     *
     * @access public
     * @param string ե̾
     * @return bool true: ɬܡfalse: Ǥ
     */
    function isReadOnly($name)
    {
        return $this->elements[$name]->isReadOnly();
    }

    /**
     * եǤɽΤߤˤ뤫
     *
     * @access public
     * @param bool եǤɽΤߥե饰
     */
    function readOnly($read_only)
    {
        foreach (array_keys($this->elements) as $key) {
            $this->elements[$key]->readOnly($read_only);
        }

        $this->results['syl_read_only'] = $read_only;
    }

    /**
     * եǤΥ顼Ƚꤹ
     *
     * @access public
     * @param string ե̾
     * @return bool true: ɬܡfalse: Ǥ
     */
    function isError($name='')
    {
        if ($name == '') {
            foreach ($this->results as $name => $value) {
                if ((substr($name, 0, 4) != 'syl_') && $value['error']) {
                    return true;
                }
          }
          return false;
        } else {
            return $this->results[$name]['error'];
        }
    }

    /**
     * 顼å򥻥åȤ
     *
     * @access public
     * @param string ե̾
     * @param string 顼å
     */
    function setErrorMessage($name, $error_message)
    {
        $this->results[$name]['error'] = true;
        $this->results[$name]['error_message'] = $error_message;
        $this->results['syl_error'] = true;
        $this->results['syl_error_message'][] = $error_message;
    }

    /**
     * եǤΥ顼
     *
     * @access public
     * @param string ե̾
     * @return string 顼å
     */
    function getErrorMessage($name)
    {
        return $this->results[$name]['error_message'];
    }

    /**
     * եǤ顼
     *
     * @access public
     * @param string ե̾
     * @return array 顼å
     */
    function getErrorMessageAll()
    {
        return $this->results['syl_error_message'];
    }

    /**
     * եॿ°򥻥å
     *
     * @access public
     * @param string եॿ°
     * @param string եॿ°
     */
    function setAttribute($key, $value)
    {
        $this->attributes[$key] = $value;
    }

    /**
     * եॿ°
     *
     * @access public
     * @return string եॿ°
     */
    function getAttributes()
    {
        $attributes = '';
        foreach ($this->attributes as $name => $value) {
            $attributes .= $name . '="' . $value . '" ';
        }
        return $attributes;
    }

    /**
     * JavaScriptϥå
     *
     * @access public
     * @return string JavaScriptϥå
     */
    function getJavaScript()
    {
        static $js_include = false;
        if (!$this->js) {
            return '';
        }

        $js  = '';
        if (!$js_include) {
            $js  = '<script language="JavaScript" src="' . $this->js_url . '"></script>' . "\r\n";
            $js_include = true;
        }
        $js .= '<script language="javascript">' . "\r\n";
        $js .= '<!--' . "\r\n";
        $js .= 'var ' . $this->js_func_name . '_submit = false;' . "\r\n";
        $js .= 'function ' . $this->js_func_name . '(f)' . "\r\n";
        $js .= '{' . "\r\n";
        $js .= 'if (' . $this->js_func_name . '_submit) {' . "\r\n";
        $js .= '  return false;' . "\r\n";
        $js .= '}' . "\r\n";
        $js .= 'var validator = new SyL_Validator(f);' . "\r\n";
        $js .= "\r\n";
        foreach (array_keys($this->elements) as $key) {
            $js .= $this->elements[$key]->getJavaScript();
        }
        $js .= 'if (!' . $this->js_func_name . '_submit) {' . "\r\n";
        $js .= '  if (validator.isError()) {' . "\r\n";
        $js .= '    validator.displayErrorMessage(true, "' . $this->js_error_header . '", "' . $this->js_error_footer . '");' . "\r\n";
        $js .= '    return false;' . "\r\n";
        $js .= '  } else {' . "\r\n";
        $js .= '    ' . $this->js_func_name . '_submit = true;' . "\r\n";
        $js .= '    return true;' . "\r\n";
        $js .= '  }' . "\r\n";
        $js .= '} else {'         . "\r\n";
        $js .= '  return false;'  . "\r\n";
        $js .= '}'                . "\r\n";
        $js .= "\r\n";
        $js .= '}'         . "\r\n";
        $js .= '//-->'     . "\r\n";
        $js .= '</script>' . "\r\n";

        return $js;
    }

    /**
     * եǤǼ
     *
     * @access public
     * @return array եǤ
     */
    function &getResultArray()
    {
        foreach (array_keys($this->elements) as $name) {
            $this->results[$name]['label']     = $this->getName($name);
            $this->results[$name]['html']      = $this->getHtml($name);
            $this->results[$name]['require']   = $this->isRequire($name);
            $this->results[$name]['read_only'] = $this->isReadOnly($name);
        }
        // եॿ°
        $this->results['syl_javascript'] = $this->getJavaScript();
        $this->results['syl_form']       = $this->getAttributes();
        return $this->results;
    }
}

?>
