<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElement.php,v 1.6 2006/12/19 13:28:23 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڥ饹
 */
require_once 'SyL_Validation.php';

/**
 * եǤδ쥯饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElement.php,v 1.6 2006/12/19 13:28:23 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElement
{
    /**
     * ե̾
     *
     * @access private
     * @var string
     */
    var $form_name = '';
    /**
     * եɽ̾
     *
     * @access private
     * @var string
     */
    var $display_name = '';
    /**
     * եHTML̾
     *
     * @access private
     * @var string
     */
    var $name = '';
    /**
     * եǤ
     *
     * @access private
     * @var string
     */
    var $value = '';
    /**
     * եHTMLη
     *
     * @access private
     * @var string
     */
    var $type = null;
    /**
     * եHTMLɲ°
     *
     * @access private
     * @var string
     */
    var $attributes = array();
    /**
     * ե
     * radio, select, checkboxΤ
     *
     * @access private
     * @var array
     */
    var $options = array();
    /**
     * ڥ롼ץ֥
     *
     * @access private
     * @var object
     */
    var $validators = null;
    /**
     * ɤ߼ѥե饰
     *
     * @access private
     * @var bool
     */
    var $read_only = false;
    /**
     * åǽȽ
     *
     * @access private
     * @var bool
     */
    var $session = false;
    /**
     * 顼å
     * 顼å''ξϡ顼̵
     *
     * @access private
     * @var string
     */
    var $error_message = '';

    /**
     * ̥եǥ֥Ȥμ
     *
     * @access public
     * @param string եǥ
     * @param string եHTML̾
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @param mixed եǤ͡checkboxξ󡢤ʳstring
     * @param string եǤɲ°
     */
    function &create($type, $name, $display_name, $options=array(), $value=null, $attributes=array())
    {
        $type = ucfirst(strtolower($type));
        $class_name = 'SyL_FormElement' . $type;
        include_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'FormElement' . DIRECTORY_SEPARATOR . $class_name . '.php';
        $element_class =& new $class_name($name, $display_name, $options, $value, $attributes);
        return $element_class;
    }

    /**
     * ڥ롼ץ֥Ȥ
     *
     * @access public
     * @return object ڥ롼ץ֥
     */
    function &createValidators()
    {
        $validators =& new SyL_Validators();
        return $validators;
    }

    /**
     * ꥯȤͤ
     *
     * @access public
     * @return mixed ꥯѿ
     */
    function getParameter()
    {
        $value = '';
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $value = isset($_POST[$this->name]) ? $_POST[$this->name] : '';
        } else {
            $value = isset($_GET[$this->name]) ? $_GET[$this->name] : '';
        }

        return $value;
    }

    /**
     * ѿФƺƵŪ˽¹Ԥ
     *
     * @access public
     * @param string ؿ̾
     * @param mixed ؿΰȤʤѿ
     */
    function parametersFilter($func, &$value)
    {
        if (is_array($value)) {
            foreach ($value as $k => $v) {
                $this->parametersFilter($method, $value[$k]);
            }
        } else {
            $value = call_user_func($func, $value);
        }
    }

    /**
     * եǤɽΤȽ
     *
     * @access public
     * @param bool եǤɽΤߥե饰
     */
    function readOnly($read_only)
    {
        $this->read_only = $read_only;
    }

    /**
     * ե̾򥻥å
     *
     * @access public
     * @param string ե̾
     */
    function setFormName($form_name)
    {
        $this->form_name = $form_name;
    }

    /**
     * ɲ°򥻥å
     *
     * @access public
     * @param string ɲ°
     */
    function setAttribute($attribute)
    {
        $this->attributes = $attribute;
    }

    /**
     * åǽȽ򥻥å
     *
     * @access public
     * @param bool åǽȽ
     */
    function setFormSession( $session )
    {
        $this->session = $session;
    }

    /**
     * ɬܥå¸Ƚ
     * ڥ롼ץ֥Ȥ򥻥åȤƤ¹Ԥ
     *
     * @access public
     * @return bool true: ɬܥåꡢfalse: ɬܥå̵
     */
    function isRequire()
    {
        return (is_object($this->validators) ? $this->validators->isRequire() : false);
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * եɽ̾
     *
     * @access public
     * @return string ̾
     */
    function getDisplayName( $group=false )
    {
        return $this->display_name;
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getValue()
    {
        return $this->value;
    }

    /**
     * 顼å
     *
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * ¾°
     *
     * @access public
     * @return string ¾°
     */
    function getAttribute()
    {
        $attributes = '';
        foreach ($this->attributes as $k => $v) {
            $attributes .= is_numeric($k) ? (' ' . $this->encodeHtml($v) . ' ') : ($k . '="' . $this->encodeHtml($v) . '" ');
        }
        return $attributes;
    }

    /**
     * եǤɽȽ
     *
     * @access public
     * @param bool եǤɽȽ
     */
    function isReadOnly()
    {
        return $this->read_only;
    }

    /**
     * եHTML
     * ɤ߼ѤˤʤäƤ뤫ǡҥ饹Υ᥽åɤƤʬ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtml()
    {
        if ($this->read_only) {
            return $this->getHtmlView();
        } else {
            return $this->getHtmlTag();
        }
    }

    /**
     * եHTMLϡɽ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        trigger_error("[SyL error] 'getHtmlView' method is not implemented in this class (" . get_class($this) . ")");
    }

    /**
     * եHTMLϡϹܡ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        trigger_error("[SyL error] 'getHtmlTag' method is not implemented in this class(" . get_class($this) . ")");
    }

    /**
     * եǤhiddenǽ
     *
     * @access public
     * @param bool true: html󥳡ɤԤfalse: html󥳡ɤԤʤ
     * @return string եǤHTML
     */
    function getHtmlHidden( $name=null, $value=null )
    {
        if (($name === null) || ($value === null)) {
            $name  = $this->name;
            $value = $this->value;
        }
        $html_element  = '';
        $html_element .= '<input type="hidden" ';
        $html_element .=   'name="'  . $name  . '" ';
        $html_element .=   'value="' . $this->encodeHtml($value) . '"';
        $html_element .= '>';

        return $html_element;
    }

    /**
     * HTML󥳡ɤԤ
     *
     * @access public
     * @param string HTML󥳡ʸ
     * @return string HTML󥳡ɸʸ
     */
    function encodeHtml($value)
    {
        return htmlspecialchars($value);
    }

    /**
     * ڥ롼ץ֥Ȥ򥻥å
     *
     * @access public
     * @param object ڥ롼ץ֥
     */
    function setValidators(&$validators)
    {
        $this->validators =& $validators;
    }

    /**
     * ڤ¹Ԥ
     * ڥ롼ץ֥Ȥʤϡtrue
     *
     * 顼å{name}ʸϡ̾Ѵ
     *
     * @access public
     * @return bool true: 顼̵false: 顼
     */
    function validate()
    {
        if (is_object($this->validators)) {
            if (!$this->validators->execute($this->value)) {
                $this->error_message = $this->validators->getErrorMessage($this->getDisplayName());
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }

    /**
     * JavaScriptϥå
     *
     * @access public
     * @return string JavaScriptϥå
     */
    function getJavaScript()
    {
        if (is_object($this->validators)) {
            $js  = '';
            $js .= 'var error_flag = false;' . "\r\n";
            $js .= 'var element_name = "' . $this->getName() . '";' . "\r\n";
            $js .= $this->validators->getJavaScript($this->getDisplayName(), $this->options);
            $js .= "\r\n";
            return $js;
        } else {
            return '';
        }
    }
}

?>
