<?php
/**
 * ե饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: action.php,v 1.2 2006/12/19 13:29:02 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Action
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Action()
    {
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     * @param object ݡͥȥ᥽åɥ֥
     */
    function execute(&$cmd, &$cm)
    {
        $project_dir  = $cmd->getArg('-d');
        $app_name     = $cmd->getArg('-w');
        $action_files = $cmd->getArg('-a');

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cnt = count($project_dir);
        if ($cnt == 0) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Project directory (-d) only 1", E_USER_ERROR);
            exit;
        }

        $project_dir = preg_match('/(\\\\|\/)$/', $project_dir[0]) ? $project_dir[0] : $project_dir[0] . '/';

        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $cnt = count($app_name);
        if ($cnt == 0) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Application name (-w) only 1", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name[0])) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        } else {
            $app_name = $app_name[0];
        }

        $app_dir = $project_dir . 'app/' . $app_name . '/';

        if (!file_exists($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        $action_dir = $app_dir . 'actions/';
        $cnt = count($action_files);
        if ($cnt == 0) {
            trigger_error("[SyL error] Action file not found", E_USER_ERROR);
            exit;
        }

        foreach ($action_files as $action_file) {
            if (!preg_match('/^(\\\\|\/)/', $action_file)) {
                $action_file = '/' . $action_file;
            }
            if (substr($action_file, -4) != '.php') {
                $action_file .= '.php';
            }
            if (file_exists($action_dir . $action_file)) {
                trigger_error("[SyL error] Already action file exists ({$action_dir}{$action_file})", E_USER_ERROR);
                exit;
            }
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        $cm->triggerApp('c_action', $project_dir, $app_name, $action_files);
    }

}

?>
