<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerWeb.php,v 1.2 2006/12/23 11:12:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ǡ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_DataManager.php';

/**
 * WEBȥ饯饹
 *
 * ++ ܥ٥
 *   1. initStream         - ȥ顼Υ󥹥ȥ饯¹Ը
 *   2.   loadStream       - ¹
 *   3.     executeStream  - ¹
 *   4.       middleStream - ¹Ը塢ӥ塼ɽ¹
 *   5.     renderStream   - ӥ塼ɽ¹
 *   6.   unloadStream     - ӥ塼ɽ¹Ը
 *   7. finalStream        - shutdown
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerWeb.php,v 1.2 2006/12/23 11:12:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ControllerWeb extends SyL_Controller
{
    /**
     * ե륿ե̾
     *
     * @access private
     * @var string
     */
    var $filter_file_name = 'filters.xml';
    /**
     * ե륿ե̾
     *
     * @access private
     * @var string
     */
    var $action_file_name = 'actions.xml';
    /**
     * ¹Ƚ
     * 
     * @access private
     * @var bool
     */
    var $is_execute_action = true;
    /**
     * ǡ饹
     * 
     * @access private
     * @var bool
     */
    var $dm = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param array Ķ
     */
    function SyL_ControllerWeb($config)
    {
        // 󥭡
        if (isset($config['action_key']) && $config['action_key']) {
            define('SYL_ACTION_KEY', $config['action_key']);
        } else {
            trigger_error("[SyL error] Controller parameter action_key not exists", E_USER_ERROR);
        }

        // ƤΥ󥹥ȥ饯
        parent::SyL_Controller($config);
    }

    /**
     * 
     *
     * @access protected
     */
    function initStream()
    {
        // Х륳ݡͥե
        $config_file = array();
        $config_file['components'] = SYL_WEBAPP_CONFIG_DIR . "/{$this->components_file_name}";
        // ٥ȼ¹
        $this->raiseEvent('initStream', $config_file);
    }

    /**
     * ¹
     *
     * @access protected
     */
    function loadStream()
    {
        // Хե륿ե
        $global_filters_file = SYL_WEBAPP_CONFIG_DIR . "/{$this->filter_file_name}";
        // ץꥱե륿ե
        $app_filters_file = SYL_APP_DIR . "/{$this->filter_file_name}";

        $config_file = array();
        $config_file['filters'] = $global_filters_file . PATH_SEPARATOR . $app_filters_file;

        // ٥ȼ¹
        $this->raiseEvent('loadStream', $config_file);
    }

    /**
     * ¹
     *
     * @access protected
     */
    function executeStream()
    {
        // ¹Ƚ
        $config_file = array();
        if ($this->isExecuteAction()) {
            // ե
            $config_file['actions'] = SYL_APP_DIR . "/{$this->action_file_name}";
        }

        // ٥ȼ¹
        $this->raiseEvent('executeStream', $config_file);
    }

    /**
     * ǽ
     * register_shutdown_function
     *
     * @access protected
     */
    function finalStream()
    {
        // ٥ȼ¹
        parent::finalStream();

        // ݡͥȤȤϿ줿destory᥽åɼ¹
        $cnt = count($this->destory_objects);
        for ($i=0; $i<$cnt; $i++) {
          call_user_func($this->destory_objects[$i]);
        }
    }

    /**
     * ȥݥ
     *
     * @access public
     */
    function stream()
    {
        // 
        $this->initStream();
        // ¹
        $this->loadStream();
        // ¹Խ
        $this->executeStream();
        // ӥ塼ɽ¹
        $this->middleStream();
        // ӥ塼ɽ¹
        $this->renderStream();
        // ӥ塼ɽ¹Ը
        $this->unloadStream();
/*
echo "<pre>";
print_r($this->container->components);
echo "</pre>";

*/
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     *
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->template_dir;
    }

    /**
     * ¹Ƚ򥻥å
     * 
     * @access public
     * @return bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function setExecuteAction($is_execute_action)
    {
        $this->is_execute_action = ($is_execute_action !== false);
    }

    /**
     * ¹Ƚ
     * 
     * @access public
     * @return bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function isExecuteAction()
    {
        return $this->is_execute_action;
    }
}

?>
