<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorCmd.php,v 1.3 2006/12/23 11:12:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEB̥顼ɽ饹
 *
 * 顼åɽѥ
 * ư顼1
 *   ̥顼ɽ
 *   end( '顼å' )
 * 
 * ư顼2
 *   ̥顼̤˥顼åߤơ쵤ɽ
 *   
 *   end(顼å֥)
 * 
 * ư顼
 *   顼ϥɥ
 *   ̥顼ɽ塢λ
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorCmd.php,v 1.3 2006/12/23 11:12:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorCmd extends SyL_Error
{
    /**
     * 顼ϥɥ顼μ
     * 
     * Loding Frameworkǥեȥ顼̤ܤȤ
     * Ѥ롣
     *
     * @access protected
     * @param int 顼No
     * @param string 顼å
     */
    function errorHandler($error_no, $error_message)
    {
        // ߤΥ顼٥뤫饨顼ɽ뤫Ƚ
        if ($error_no & error_reporting()) {
            // Хåե󥰥ꥢ
            while (@ob_end_clean());

            // ʣ顼åб
            if (count($this->error_message) > 0) {
                if ($error_message != '') {
                    $error_message .= $this->eof;
                }
                foreach ($this->error_message as $tmp) {
                    $error_message .= $tmp . $this->eof;
                }
            }
            // 顼פμ
            $error_type  = $this->getErrorType($error_no);
            // 顼ȥ졼μ
            $error_trace = SYL_ERROR_TRACE ? $this->getTraceConsole() : '';
            // 顼å
            $error_string = SYL_ERROR ? "[{$error_type}] {$error_message}" : SYL_ERROR_MESSAGE;
            // 顼ɽ
            $this->displayErrorDefault($error_string, $error_trace);
            // 
            $this->logging($error_no, $error_message);

            exit;
        } else {
            // 
            $this->logging($error_no, $error_message);
        }
    }

    /**
     * ǥեȥ顼
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     */
    function displayErrorDefault($error_string, $error_trace)
    {
        echo $error_string;
        if ($error_trace) {
            echo $this->eof;
            echo $error_trace;
        }
    }

    /**
     * 顼ȥ졼
     *
     * @access public
     * @return string 顼ȥ졼
     */
    function getTraceConsole()
    {
        $error_trace = $this->getTrace();
        $i = count($error_trace);
        $error_trace_result = '';
        if ($i > 0) {
            // 顼ȥ졼ɽκ
            $error_trace_result .= "------ start Debug Trace ------" . $this->eof;
            foreach ($error_trace as $value) {
                if (($value['function'] == '') || ($value['function'] == 'unknown')) {
                    $value['function'] = '';
                }
                if ($value['file'] == '') {
                    $value['file'] = '-';
                }
                if ($value['line'] == '') {
                    $value['line'] = '-';
                }
                $error_trace_result .= "{$i}. [file] {$value['file']} [line] {$value['line']} [function] {$value['function']}" . $this->eof;
                $i--;
            }
            $error_trace_result .= "------ end Debug Trace ------" . $this->eof;
        }

        return $error_trace_result;
    }
}
?>
