<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.7 2006/12/23 11:12:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEB̥顼ɽ饹
 *
 * 顼åɽѥ
 * ư顼1
 *   ̥顼ɽ
 *   end( '顼å' )
 * 
 * ư顼2
 *   ̥顼̤˥顼åߤơ쵤ɽ
 *   
 *   end(顼å֥)
 * 
 * ư顼
 *   顼ϥɥ
 *   ̥顼ɽ塢λ
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.7 2006/12/23 11:12:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorWeb extends SyL_Error
{
    /**
     * 顼ϥɥ顼μ
     * 
     * Loding Frameworkǥեȥ顼̤ܤȤ
     * Ѥ롣
     *
     * @access protected
     * @param int 顼No
     * @param string 顼å
     */
    function errorHandler($error_no, $error_message)
    {
        // ߤΥ顼٥뤫饨顼̤ɽ뤫Ƚ
        if ($error_no & error_reporting()) {
            // Хåե󥰥ꥢ
            while (@ob_end_clean());

            // ʣ顼åб
            if (count($this->error_message) > 0) {
                if ($error_message != '') {
                    $error_message .= "<br>";
                }
                foreach ($this->error_message as $tmp) {
                    $error_message .= $tmp . "<br>";
                }
            }
            // 顼פμ
            $error_type  = $this->getErrorType($error_no);
            // 顼ȥ졼μ
            $error_trace = SYL_ERROR_TRACE ? $this->getTraceHtml() : '';

            // 顼ɽȽ
            $error_View_type = '';
            switch (strtolower(SYL_ERROR_FORWARD_TYPE)) {
            case 'template': $error_View_type = 'Template'; break;
            case 'redirect': $error_View_type = 'Redirect'; break;
            default:         $error_View_type = 'Default';  break;
            }

            // 顼ɽ
            $func_name = "displayError{$error_View_type}";
            // 顼å
            $error_string = SYL_ERROR ? "[{$error_type}] {$error_message}" : SYL_ERROR_MESSAGE;
            call_user_func(array(&$this, $func_name), $error_string, $error_trace);
            // 
            $this->logging($error_no, $error_message);

            exit;
        } else {
            // 
            $this->logging($error_no, $error_message);
        }
    }

    /**
     * ǥեȥ顼
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     */
    function displayErrorDefault($error_string, $error_trace)
    {
        echo $error_string;
        if ($error_trace) {
            echo "<br><br>";
            echo $error_trace;
        }
    }

    /**
     * ƥץ졼ȥ顼
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     */
    function displayErrorTemplate($error_string, $error_trace)
    {
        if (is_file(SYL_WEBAPP_LIB_DIR . '/' . SYL_ERROR_FORWARD_FILE)) {
            // 顼ƥץ졼ɤ߹
            // $error_string
            // $error_trace
            include_once SYL_WEBAPP_LIB_DIR . '/' . SYL_ERROR_FORWARD_FILE;
        } else {
            trigger_error("[SyL error] error template not found (" . SYL_WEBAPP_LIB_DIR . '/' . SYL_ERROR_FORWARD_FILE . ")", E_USER_ERROR);
        }
    }

    /**
     * 顼ڡ˥쥯
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     */
    function displayErrorRedirect($error_message, $error_trace)
    {
        SyL_Response::redirect(SYL_ERROR_FORWARD_FILE);
    }

    /**
     * 顼ȥ졼
     *
     * @access public
     * @return string 顼ȥ졼
     */
    function getTraceHtml()
    {
        $error_trace = $this->getTrace();
        $i = count($error_trace);
        $error_trace_result = '';
        if ($i > 0) {
            // 顼ȥ졼ɽκ
            $error_trace_result .= '<table border="1" cellspacing="0" cellpadding="3" bgcolor="#FFFFFF">' . "\r\n";
            $error_trace_result .= '<tr>' . "\r\n";
            $error_trace_result .= '<td colspan="4">Debug Trace</td>' . "\r\n";
            $error_trace_result .= '</tr>' . "\r\n";
            $error_trace_result .= '<tr>'  . "\r\n";
            $error_trace_result .= '<td bgcolor="#CCCCCC">#</td>';
            $error_trace_result .= '<td bgcolor="#CCCCCC">file</td>';
            $error_trace_result .= '<td bgcolor="#CCCCCC">line</td>';
            $error_trace_result .= '<td bgcolor="#CCCCCC">function or method</td>' . "\r\n";
            $error_trace_result .= '</tr>' . "\r\n";
            foreach ($error_trace as $value) {
                if (($value['function'] == '') || ($value['function'] == 'unknown')) {
                    $value['function'] = '&nbsp;';
                }
                if ($value['file'] == '') {
                    $value['file'] = '-';
                }
                if ($value['line'] == '') {
                    $value['line'] = '-';
                }
                $error_trace_result .= '<tr>' . "\r\n";
                $error_trace_result .= '<td>' . $i-- . '</td>';
                $error_trace_result .= '<td>' . $value['file'] . '</td>';
                $error_trace_result .= '<td align="right">' . $value['line'] . '</td>';
                $error_trace_result .= '<td>' . $value['function'] . '</td>' . "\r\n";
                $error_trace_result .= '</tr>' . "\r\n";
            }
            $error_trace_result .= '</table>' . "\r\n";
        }

        return $error_trace_result;
    }
}
?>
