<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.7 2006/12/23 11:12:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ɽ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.7 2006/12/23 11:12:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_View
{
    /**
     * ɽƤΥǡ
     * 
     * @access protected
     * @var string
     */
    var $render = '';
    /**
     * ǡ֥
     * 
     * @access protected
     * @var object
     */
    var $dm = null;
    /**
     * ݡͥȥ᥽åɥ֥
     * 
     * @access protected
     * @var object
     */
    var $cm = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_View(&$dm, &$cm)
    {
        $this->dm =& $dm;
        $this->cm =& $cm;
    }

    /**
     * ƥץ졼ȥ֥Ȥ
     * 
     * @access public
     * @param object ӥ塼ǡ֥
     * @return object ӥ塼֥
     */
    function &getObject(&$dm, &$cm)
    {
        $class_name   = '';
        $include_file = '';
        $type = $dm->getTemplateType();
        if (strtolower($type) == 'customize') {
            $class_name   = $dm->getCustomizedViewClass();
            $include_file = $dm->getCustomizedViewFile();
            if (!is_file($include_file)) {
                $include_file1 = SYL_WEBAPP_LIB_DIR . "/{$include_file}";
                if (!is_file($include_file1)) {
                    trigger_error("[SyL error] Customised View file not found ({$include_file} or {$include_file1})", E_USER_ERROR);
                }
                $include_file = $include_file1;
            }
        } else {
            $class_name = 'SyL_View' . ucfirst($type);
            $include_file = SYL_INCLUDE_DIR . "/framework/View/{$class_name}.php";
        }
        include_once $include_file;
        $view =& new $class_name($dm, $cm);
        return $view;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->dm->getTemplateDir();
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        return $this->dm->getTemplateFile();
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ӥ塼Ϥѥ᡼
     */
    function &getActionValues()
    {
        // 󥪥֥ȼ
        $action =& $this->dm->getAction();
        // 
        $values = array();
        // ѥ᡼
        if (is_object($action)) {
            // 󥪥֥Ȥ¸ߤʥ¹ԸˤʤС
            // ץѥƥ
            foreach (get_object_vars($action) as $key => $value) {
                if (substr($key, 0, 1) != '_') {
                    if (is_object($value)) {
                        $values[$key] =& $value;
                    } else {
                        $values[$key] = $value;
                    }
                }
            }
        } else {
            // 󥪥֥Ȥ¸ߤʤʥ¹̵ˤʤС
            // Υ饹ǥեȥץѥƥ
            $action_file = $this->dm->getActionDir() . $this->dm->getActionFile();
            if (is_file($action_file)) {
                include_once($action_file);
                $action_class = $this->dm->getClassName();
                if (class_exists($action_class)) {
                    foreach (get_class_vars($action_class) as $key => $value) {
                        $values[$key] = $value;
                    }
                }
            }
        }

        return $values;
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
    }

    /**
     * ɽƤ򥻥å
     * 
     * @access public
     * @param string ɽ
     */
    function setRender($render)
    {
        $this->render = $render;
    }

    /**
     * ɽƤ
     * 
     * @access public
     */
    function getRender()
    {
        return $this->render;
    }
}


?>
