<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LayoutSmarty.php,v 1.2 2007/01/15 15:55:12 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Smarty饹
 */
require_once SYL_SMARTY_DIR . 'Smarty.class.php';

/**
 * Smarty쥤ȥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LayoutSmarty.php,v 1.2 2007/01/15 15:55:12 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_LayoutSmarty extends SyL_Layout
{
    /**
     * Smarty֥
     * 
     * @var object
     */
    var $smarty = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_LayoutSmarty(&$dm)
    {
        parent::SyL_Layout($dm);

        $this->smarty =& new Smarty();
        $this->smarty->compile_dir = SYL_SMARTY_COMPILE_DIR;
        $this->smarty->config_dir  = SYL_SMARTY_CONFIG_DIR;
        $this->smarty->cache_dir   = SYL_SMARTY_CACHE_DIR;
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        // 󤫤Υѥ᡼
        $values =& $this->getActionValues();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key])) {
                $this->smarty->assign_by_ref($key, $values[$key]);
            } else {
                $this->smarty->assign($key, $values[$key]);
            }
        }

        // ƥץ졼ȥǥ쥯ȥꥻå
        $this->smarty->template_dir = $this->getTemplateDir();
        // ɽƤ򥻥å
        $this->setRender($this->smarty->fetch($this->getTemplateFile()));
    }
}

?>
