<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Cache.php,v 1.9 2007/01/15 15:55:12 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * LbVNX
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Cache.php,v 1.9 2007/01/15 15:55:12 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Cache
{
    /**
     * LbṼL[
     *
     * @access private
     * @var string
     */
    var $key = '';
    /**
     * LbṼL[MD5
     *
     * @access private
     * @var string
     */
    var $key_md5 = '';
    /**
     * LbVfBNg
     *
     * @access private
     * @var string
     */
    var $cache_dir = '/tmp/';
    /**
     * LbVt@C̐ړ
     *
     * @access private
     * @var string
     */
    var $prefix = 'syl_cache.';
    /**
     * LbVt@C̗L
     * Pʂ͕b[s]
     *
     * @access private
     * @var int
     */
    var $life_time = 3600; // 1

    /**
     * RXgN^
     *
     * @access public
     */
    function SyL_Cache($key)
    {
        clearstatcache();
        $this->key     = $key;
        $this->key_md5 = md5($key);
    }

    /**
     * LbVIuWFNg擾
     *
     * @static
     * @access public
     * @param string LbṼL[
     * @param string LbV^Cv
     */
    function &getObject($key, $type='')
    {
        if ($type != '') {
            $class_name = 'SyL_Cache' . ucfirst($type);
            include_once dirname(__FILE__) . "/Cache/{$class_name}.php";
        } else {
            $class_name = 'SyL_Cache';
        }
        $object =& new $class_name($key);
        return $object;
    }

    /**
     * LbVfBNgZbg
     *
     * @access public
     * @param string LbVfBNg
     */
    function setCacheDir($cache_dir)
    {
        if (!preg_match('/(\\\\|\/)$/', $cache_dir)) {
            $cache_dir .= '/';
        }

        if (!is_dir($cache_dir)) {
            if (!mkdir($cache_dir, 0777)) {
                trigger_error("[SyL error] SyL cache dir can't create ($cache_dir)", E_USER_ERROR);
            }
        }

        if (!is_writable($cache_dir)) {
            trigger_error("[SyL error] SyL cache dir permission denied ($cache_dir)", E_USER_ERROR);
        }

        $this->cache_dir = $cache_dir;
    }

    /**
     * LbVt@C̐ړZbg
     *
     * @access public
     * @param string LbVt@C̐ړ
     */
    function setPrefix($prefix)
    {
        $this->prefix = $prefix;
    }

    /**
     * LbVLԂZbg
     *
     * @access public
     * @param int LbVLԁib[s]j
     */
    function setLifeTime($life_time)
    {
        $this->life_time = $life_time;
    }

    /**
     * LbVt@Cǂݍ
     *
     * @access public
     * @param string LbVL[l
     * @param bool LbVLԂXV
     * @return mixed LbVf[^
     */
    function read($modify_time_update=false)
    {
        $filename = $this->getFileName();
        if (!$filename) {
            return false;
        }
        if (file_exists($filename)) {
            // LbVt@COK
            if ($this->life_time !== null) {
                $mtime = filemtime($filename);
                $life_time = $mtime + $this->life_time;
            } else {
                $life_time = null;
            }

            if (($life_time === null) || ($life_time >= time())) {
                // LbVLOK
                if (!($fp = @fopen($filename, "rb"))) {
                    return false;
                }
                $mqr = get_magic_quotes_runtime();
                set_magic_quotes_runtime(0);
                $len = filesize($filename);

                flock($fp, LOCK_SH);
                $hash = fread($fp, 32);
                $data = ($len > 0) ? fread($fp, $len-32) : '';
                flock($fp, LOCK_UN);

                set_magic_quotes_runtime($mqr);
                fclose($fp);

                if ($hash == $this->hash($data)) {
                    if ($modify_time_update) {
                        $this->setModifyTime();
                    }
                    return unserialize($data);
                } else {
                    $this->delete($filename);
                    return false;
                }
            } else {
                // LbVLԐ؂
                $this->delete($filename);
                return false;
            }
        } else {
            // LbVt@C
            return false;
        }
    }

    /**
     * LbVt@Cۑ
     *
     * @access private
     * @param string LbVL[l
     * @param mixed LbVf[^
     * @param int XV(UNIX Time)
     * @return bool true: ۑAfalse: ۑG[
     */
    function write($data, $mtime=false)
    {
        // LbVt@C擾
        $filename = $this->getFileName();
        if (!$filename) {
            return false;
        }
        // f[^̃VA
        $data = serialize($data);
        // f[^̃oCg擾
        $len = strlen($data);
        if (!($fp = @fopen($filename, 'wb'))) {
            return false;
        }
        flock($fp, LOCK_EX);
        fwrite($fp, $this->hash($data), 32);
        fwrite($fp, $data, $len);
        flock($fp, LOCK_UN);
        fclose($fp);

        @chmod($filename, 0777);

        if ($mtime) {
            $this->setModifyTime($mtime);
        }
        return true;
    }

    /**
     * fBNg̃LbVt@C𐮗
     *
     * @access private
     * @return bool true: Afalse: G[
     */
    function clean()
    {
        if ($this->life_time === null) {
            return true;
        }
        if (!is_dir($this->cache_dir)) {
            return false;
        }
  
        $dh = opendir($this->cache_dir);
        if (!$dh) {
            return false;
        }
        $reg = '/^(' . preg_quote($this->prefix) . ')(.+)$/';
        while (($filename = readdir($dh)) !== false) {
            if (preg_match($reg, $filename)) {
                $life_time = filemtime($this->cache_dir . $filename) + $this->life_time;
                if ($life_time < time()) {
                    $this->delete($this->cache_dir . $filename);
                }
            }
        }
        closedir($dh);
    }

    /**
     * LbVt@C̍XVԂXV
     *
     * @access public
     * @param string LbVt@CL[
     * @param int XV(UNIX Time)
     * @return bool true: XVOKAfalse: XVG[
     */
    function setModifyTime($mtime='')
    {
        $filename = $this->getFileName();
        if (!$filename) {
            return false;
        }
        if (!file_exists($filename)) {
            return false;
        }
        return ($mtime) ? touch($filename, $mtime) : touch($filename);
    }

    /**
     * LbVt@C̍XVԂ擾
     *
     * @access public
     * @param string LbVt@CL[
     * @return int XV(UNIX Time)
     */
    function getModifyTime()
    {
        $filename = $this->getFileName();
        if (!$filename) {
            return false;
        }
        if (!file_exists($filename)) {
            return false;
        }
        return filemtime($filename);
    }

    /**
     * LbVt@C擾
     * 
     * @access public
     * @param string LbVt@CL[
     * @return string LbVt@C
     */
    function getFileName()
    {
        return $this->cache_dir . $this->prefix . $this->key_md5;
    }

    /**
     * LbV폜
     * 
     * @access public
     */
    function delete($file='')
    {
        if (!$file) {
            $file = $this->getFileName();
        }
        @unlink($file);
    }


    /**
     * nbVl擾
     * 
     * @access public
     * @param string f[^
     * @return string nbVl
     */
    function hash($data)
    {
        return sprintf('%+032d', crc32($data));
    }
}

?>
