<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerCmd.php,v 1.5 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ޥɥ饤󥳥ȥ饯饹
 *
 * ++ ܥ٥
 *   1. initStream       - ȥ顼Υ󥹥ȥ饯¹Ը
 *   2.   loadStream       - ¹
 *   3.     executeStream  - ¹
 *   4.   unloadStream   - ӥ塼ɽ¹Ը
 *   5. finalStream      - shutdown
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ControllerCmd.php,v 1.5 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ControllerCmd extends SyL_Controller
{
    /**
     * ե륿ե̾
     *
     * @access private
     * @var string
     */
    var $action_file_name = 'actionscmd.xml';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param array Ķ
     */
    function SyL_ControllerCmd($config)
    {
        parent::SyL_Controller($config);
    }

    /**
     * 
     *
     * @access protected
     */
    function initStream()
    {
        // Х륳ݡͥե
        $config_file = array();
        $config_file['components'] = SYL_WEBAPP_CONFIG_DIR . "/{$this->components_file_name}";
        // ٥ȼ¹
        $this->raiseEvent('initStream', $config_file);
    }

    /**
     * ¹
     *
     * @access protected
     */
    function executeStream()
    {
        // ե
        $config_file = array();
        $config_file['actionscmd'] = SYL_APP_DIR . "/{$this->action_file_name}";

        // ٥ȼ¹
        $this->raiseEvent('executeStream', $config_file);
    }

    /**
     * ȥݥ
     *
     * @access public
     */
    function stream()
    {
        // 
        $this->initStream();
        // ¹
        $this->loadStream();
        // ¹Խ
        $this->executeStream();
        // ¹Ը
        $this->unloadStream();
/*
echo "<pre>";
print_r($this->container->components);
echo "</pre>";

*/
    }
}

?>
