<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorAjax.php,v 1.1 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Ajax顼饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorAjax.php,v 1.1 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorAjax extends SyL_Error
{
    /**
     * 顼ϥɥ顼μ
     * 
     * @access public
     */
    function errorHandler()
    {
        // Хåե󥰥ꥢ
        // ɬ
        ob_clean();

        // 顼פμ
        $error_type = $this->getErrorType();
        // 顼å
        $error_message = implode($this->eof, $this->getErrorMessages());

        // 顼å
        $error_string = SYL_ERROR ? "[{$error_type}] {$error_message}" : SYL_ERROR_MESSAGE;
        // 顼åɽ
        $this->displayErrorDefault($error_string);
        // 
        $this->logging();
        // 顼᡼
        $this->sendMail();
    }

    /**
     * ǥեȥ顼
     *
     * @access private
     * @param string 顼å
     * @param string 顼ȥ졼
     * @param string ӥ塼
     */
    function displayErrorDefault($error_string)
    {
        // ̱饹
        if ($this->dm->getActionName() != '') {
            SyL_Response::setStatusHeader('500');
            $content_type = 'application/json; charset=' . SYL_ENCODE_AJAX;
            $error_string = mb_convert_encoding($error_string, SYL_ENCODE_AJAX, SYL_ENCODE_INTERNAL);
        } else {
            $content_type = 'application/x-javascript; charset=' . SYL_ENCODE_INTERNAL;
            if ($error_string) {
                $tmp  = '';
                $tmp .= 'document.writeln("<div style=\'color: #CC0000; font-weight: bold;\'>");';
                $tmp .= 'document.writeln("' . str_replace('"', '\\"', $error_string) . '");';
                $tmp .= 'document.writeln("</div>");';
                $error_string = $tmp;
            }
        }

        // JavaScirptƥĥ
        SyL_Response::setHeader('Content-Type', $content_type);
        $response =& SyL_Response::getInstance();
        $response->display($error_string);
    }
}

?>
