<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataManager.php,v 1.6 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݡͥȥ᥽åɥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_ComponentMethod.php';

/**
 * ե졼ǡ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataManager.php,v 1.6 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataManager
{
    /**
     * ƥץ졼ȥե
     * 
     * @access private
     * @var string
     */
    var $template_file = '';
    /**
     * ӥ塼ѥ᡼
     * 
     * @access private
     * @var array
     */
    var $view_parameters = array();
    /**
     * ѥ᡼
     * 
     * @access private
     * @var string
     */
    var $parameters = array();
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * 롼֥
     * 
     * @access private
     * @var object
     */
    var $router = null;
    /**
     * ݡͥȥ᥽åɥ֥
     * 
     * @access private
     * @var object
     */
    var $cm = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ饪֥
     */
    function SyL_DataManager(&$controller)
    {
        $this->cm =& new SyL_ComponentMethod($controller);
        $this->controller =& $controller;
    }

    /**
     * ܾ󥪥֥Ȥ򥻥å
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function setRouter(&$router)
    {
        $this->router =& $router;
        // ǥХå - ξ
        SyL_Loggers::debug("[DataManager] action info - name: " . $this->getActionName() . " dir: " . $this->getActionDir() . " file: " . $this->getActionFile() . " class: " . $this->getClassName());
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getActionName()
    {
        return is_object($this->router) ? $this->router->getActionName() : null;
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ
     */
    function getActionDir()
    {
        return $this->controller->getActionDir();
    }

    /**
     * ե
     *
     * @access public
     * @return string ե
     */
    function getActionFile()
    {
        return is_object($this->router) ? $this->router->getActionFile() : null;
    }

    /**
     * 饹̾
     *
     * @access public
     * @return string 饹̾
     */
    function getClassName()
    {
        return is_object($this->router) ? $this->router->getClassName() : null;
    }

    /**
     * PATH_INFO
     *
     * @access public
     * @return array PATH_INFO
     */
    function getPathInfoArray()
    {
        return is_object($this->router) ? $this->router->getPathInfoArray() : null;
    }

    /**
     * ƥץ졼ȥե򥻥å
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->convertPath($this->controller->getTemplateDir(), true);
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        $template_dir  = $this->getTemplateDir();
        $template_file = $this->convertPath($this->template_file, false);

        // ǥХå - ƥץ졼Ȥξ
        SyL_Loggers::debug("[DataManager] template info  dir: {$template_dir} file: {$template_file}");

        // ƥץ졼ȥե¸ߥå
        if (!is_file($template_dir . $template_file)) {
            SyL_Response::redirect404();
        }
        return $template_file;
    }

    /**
     * ӥ塼ѥ᡼å
     * 
     * @access public
     * @param string ӥ塼ѥ᡼̾
     * @param string ӥ塼ѥ᡼
     */
    function setViewParameter($name, $value)
    {
        $this->view_parameters[$name] = $value;
    }

    /**
     * ӥ塼ѥ᡼
     * 
     * @access public
     * @param string ӥ塼ѥ᡼̾
     * @return string ӥ塼ѥ᡼
     */
    function getViewParameter($name)
    {
        return isset($this->view_parameters[$name]) ? $this->view_parameters[$name] : '';
    }

    /**
     * ѥ
     * 
     * @access public
     * @param string ѥ
     * @return string ѥ
     */
    function convertPath($path, $is_dir_path=false)
    {
        if ($is_dir_path && !preg_match('/(\\\\|\/)$/', $path)) {
            $path .= '/';
        } else if (!$is_dir_path) {
            while (preg_match('/^(\\\\|\/)/', $path)) {
                $path = substr($path, 1);
            }
        }
        return $path;
    }

    /**
     * ե륿ͤ
     * 
     * @access public
     * @param string ե륿̾
     * @return mixed ե륿
     */
    function triggerFilter($name)
    {
        $args = func_get_args();
        array_shift($args);
        return $this->cm->triggerFilter($name, $args);
    }

    /**
     * ץꥱ󥳥ݡͥȤͤ
     * 
     * @access public
     * @param string ץꥱ󥳥ݡͥ̾
     * @return mixed ץꥱ󥳥ݡͥȤ
     */
    function triggerApp($name)
    {
        $args = func_get_args();
        array_shift($args);
        return $this->cm->triggerApp($name, $args);
    }

    /**
     * ¹Ƚ򥻥å
     * 
     * @access public
     * @param bool true: ¹Ԥ롢false: ¹Ԥʤ
     */
    function setExecuteAction($is_execute_action)
    {
        $this->controller->setExecuteAction($is_execute_action);
    }

    /**
     * ݡͥȥ֥Ȥ򥻥å
     * 
     * @access public
     * @param string ݡͥ̾
     * @return object ݡͥ
     */
    function &getComponent($name)
    {
        return $this->controller->container->getComponent($name);
    }


    /**
     * 쥤ȥѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param mixed ѥ᡼
     */
    function setParameter($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * 쥤ȥѥ᡼򥻥åȡʻȡ
     *
     * @access public
     * @param string ѥ᡼̾
     * @param mixed ѥ᡼
     */
    function setParameterRef($name, &$value)
    {
        $this->parameters[$name] =& $value;
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ѥ᡼
     */
    function &getParameters()
    {
        return $this->parameters;
    }

    /**
     * 󥪥֥Ȥ򥻥å
     * 
     * @access public
     */
    function setActionValues()
    {
        if ($this->controller->container->isComponent(SYL_ACTION_KEY)) {
            $action =& $this->getComponent(SYL_ACTION_KEY);

            // 󥪥֥Ȥ¸ߤʥ¹ԸˤʤС
            // ץѥƥ
            foreach (get_object_vars($action) as $key => $value) {
                if (substr($key, 0, 1) != '_') {
                    if (is_object($value)) {
                        $this->setParameterRef($key, $value);
                    } else {
                        $this->setParameter($key, $value);
                    }
                }
            }

            // ץꥱ󥳥ݥͥȺ
            $this->cm->deleteAppComponent();
            // 󥪥֥Ⱥ
            unset($action);
            $this->controller->container->deleteComponent(SYL_ACTION_KEY);
        } else {
            // 󥪥֥Ȥ¸ߤʤʥ¹̵ˤʤС
            // Υ饹ǥեȥץѥƥ
            $action_file = $this->getActionDir() . $this->getActionFile();
            if (is_file($action_file)) {
                include_once $action_file;
                $action_class = $this->getClassName();
                if (class_exists($action_class)) {
                    foreach (get_class_vars($action_class) as $key => $value) {
                        $this->setParameter($key, $value);
                    }
                }
            }
        }
    }
}

?>
