<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AjaxClient.php,v 1.1 2007/01/28 07:13:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * AjaxJavaScript饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AjaxClient.php,v 1.1 2007/01/28 07:13:25 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AjaxClient
{
    /**
     * AjaxURL
     *
     * @access private
     * @var string
     */
    var $url = '/';
    /**
     * 󥭡
     *
     * @access private
     * @var string
     */
    var $action_key = 'action';
    /**
     * åID
     *
     * @access private
     * @var string
     */
    var $sid = '';
    /**
     * ɽ⡼
     *
     * @access private
     * @var array
     */
    var $mode = array(
      'progress' => false
    );

    /**
     * AjaxURL򥻥å
     *
     * @access public
     * @param string URL
     */
    function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * 󥭡򥻥å
     *
     * @access public
     * @param string 󥭡
     */
    function setActionKey($action_key)
    {
        $this->action_key = $action_key;
    }

    /**
     * åID򥻥å
     *
     * @access public
     * @param string åID
     */
    function setSessionId($sid)
    {
        $this->sid = $sid;
    }

    /**
     * ץ쥹С饤֥λ
     *
     * @access public
     * @param bool ץ쥹С饤֥λȽ
     */
    function isProgress($mode)
    {
        $this->mode['progress'] = ($mode === true);
    }

    /**
     * JavaScript
     *
     * @access public
     * @return string JavaScript
     */
    function getJs()
    {
        $url        = $this->url;
        $sid        = $this->sid;
        $action_key = $this->action_key;

        $js = '';
        $base_dir = dirname(__FILE__);
        ob_start();
        // ᥤ
        include_once "{$base_dir}/AjaxClient/SyL_Ajax.js";
        // ץ쥹С
        if ($this->mode['progress']) {
             include_once "{$base_dir}/AjaxClient/SyL_AjaxProgressBar.js";
        }
        $js = ob_get_contents();
        ob_end_clean();

        // ǥȺ
        $js = preg_replace('/(\r\n|\r|\n)[ ]*/', "\n", $js);

        return $js;
    }
}

?>
