<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.2 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤եɤ߹९饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigLayouts.php,v 1.2 2007/01/21 08:12:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigLayouts extends SyL_Config
{
    /**
     * ե̾
     * 
     * @access private
     * @var string
     */
    var $action_file = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string XMLե̾
     */
    function SyL_ConfigLayouts($file_name)
    {
        // ƥ饹Υ󥹥ȥ饯
        parent::SyL_Config($file_name);
    }

    /**
     * ȥ򥻥å
     * С饤
     *
     * @access public
     * @param object ȥ饪֥
     */
    function setController(&$controller)
    {
        $dm =& $controller->container->getComponent('datamanager');
        $this->action_file = $dm->getActionFile();
    }

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXML()
    {
        if (SYL_WEBAPP_CACHE_DIR) {
            // åѤ
            $key = implode('', $this->file_names) . $this->action_file;
            $cache =& SyL_Cache::getObject($key, 'fileupdate');
            $cache->setCacheDir(SYL_WEBAPP_CACHE_DIR . '/layouts');
            $this->config = $cache->read($this->file_names);
            if (!$this->config) {
                parent::parseXML();
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXML();
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name  = '';
        static $method_name = '';
        static $load        = false;

//echo $current_path . "<br>";
        // 1ɺѤߤξʹߥå
        if ($load) return;

        // XMLϷ̤
        switch ($current_path) {
        case '/layouts/layout':
            if ($name != '') {
                $name = '';
                $load = true;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // ̾ǧ
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            if (preg_match('/^' . $reg . '$/', $this->action_file)) {
                $name = 'dummy';
                $this->config['file']       = $attribute['file'];
                $this->config['templates']  = array();
                $this->config['view']       = array();
                $this->config['parameters'] = array();
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/layouts/layout/template':
               $this->config['templates'][$attribute['name']] = $attribute['file'];
               break;

            case '/layouts/layout/view':
                $this->config['view'][$attribute['name']] = '';
               break;

            case '/layouts/layout/parameters/parameter':
               $this->config['parameters'][$attribute['name']] = $attribute['value'];
               break;
            }
        }
    }
}

?>
