<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilInfo.php,v 1.2 2007/02/17 14:28:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SyLĶɽ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilInfo.php,v 1.2 2007/02/17 14:28:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilInfo
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_UtilInfo()
    {
    }

    /**
     * ɽ
     *
     * @access public
     * @param string ɽ
     * @return string ɽ
     */
    function formatValue($value)
    {
        $scalar = is_string($value);
        $value = nl2br(str_replace(' ', '&nbsp;', htmlspecialchars(var_export($value, true))));
        return $scalar ? substr($value, 1, -1) : $value;
    }

    /**
     * SyLĶɽ
     *
     * @access public
     * @param array ɽ
     * @param array ɽоʬʸ
     * @param bool HTMLɽե饰
     */
    function display($display=array(), $not_display_const=array(), $format=false)
    {
        $display           = array_map("strtoupper", $display);
        $not_display_const = array_map("strtoupper", $not_display_const);
?>

<?php if ($format) { ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html><head><title>sylinfo()</title></head><body>
<?php } ?>

<center>
<style type="text/css">
table.sylinfo {border-collapse: collapse;}
table.sylinfo th,
table.sylinfo td {text-align: left; border: 1px solid #000000; color: #000000; font-size: 10px; font-family: sans-serif; vertical-align: top;}
table.sylinfo th.sylinfo_h {background-color: #6699FF;}
table.sylinfo td.sylinfo_i {background-color: #6699FF; height: 86px;}
table.sylinfo td.sylinfo_i h1 {font-size: 150%;}
table.sylinfo td.sylinfo_e {background-color: #C5D8E3; font-weight: bold;}
table.sylinfo td.sylinfo_v {background-color: #CCCCCC;}
h2.sylinfo {font-size: 125%; color: #000000; font-family: sans-serif;}
hr.sylinfo {width: 600px; background-color: #CCCCCC; border: 0px; height: 1px; color: #000000;}
</style>

<?php if ($format) { ?>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><td class="sylinfo_i"><h1>SyL Version <?= SYL_VERSION ?></h1></td></tr>
</table>
<br />
<?php } else { ?>
<br />
<hr class="sylinfo">
<br />
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<tr><td class="sylinfo_e">SyL</td><td class="sylinfo_v"><?= SYL_VERSION ?></td></tr>
</table>
<br />
<?php } ?>


<h2>SYSTEM</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<tr><td class="sylinfo_e">SYSTEM</td><td class="sylinfo_v"><?= php_uname() ?></td></tr>
<tr><td class="sylinfo_e">PHP</td><td class="sylinfo_v"><?= phpversion() ?>&nbsp;(Zend engine <?= zend_version() ?>)</td></tr>
<tr><td class="sylinfo_e">SAPI</td><td class="sylinfo_v"><?= php_sapi_name() ?></td></tr>
<tr><td class="sylinfo_e">include_path</td><td class="sylinfo_v"><?= get_include_path() ?></td></tr>
<tr><td class="sylinfo_e">script_owner</td><td class="sylinfo_v"><?= get_current_user() ?></td></tr>
<?php if (function_exists('memory_get_usage')) { ?>
<tr><td class="sylinfo_e">memory_get_usage</td><td class="sylinfo_v"><?= memory_get_usage() ?></td></tr>
<?php } ?>
<?php if (function_exists('memory_get_peak_usage')) { ?>
<tr><td class="sylinfo_e">memory_get_peak_usage</td><td class="sylinfo_v"><?= memory_get_peak_usage() ?></td></tr>
<?php } ?>
<?php if (function_exists('getrusage')) { ?>
<tr><td class="sylinfo_e">getrusage</td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue(getrusage()) ?></td></tr>
<?php } ?>
</table>
<br />


<?php
// =========================================================
// GET
// =========================================================
if (!$display || in_array('GET', $display)) {
?>
<h2>$_GET</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php if (isset($_GET)) { foreach ($_GET as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// POST
// =========================================================
if (!$display || in_array('POST', $display)) {
?>
<h2>$_POST</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php if (isset($_POST)) { foreach ($_POST as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// COOKIE
// =========================================================
if (!$display || in_array('COOKIE', $display)) {
?>
<h2>$_COOKIE</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php if (isset($_COOKIE)) { foreach ($_COOKIE as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// SESSION
// =========================================================
if (!$display || in_array('SESSION', $display)) {
?>
<h2>$_SESSION</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php if (isset($_SESSION)) { foreach ($_SESSION as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// SERVER
// =========================================================
if (!$display || in_array('SERVER', $display)) {
?>
<h2>$_SERVER</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php if (isset($_SERVER)) { foreach ($_SERVER as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// CONTAINER
// =========================================================
if (!$display || in_array('CONTAINER', $display)) {
?>
<h2>CONTAINER</h2>
<?php $container =& SyL_Container::getContainer(); ?>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Type</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($container->getConfig() as $name => $value) { ?>
  <tr>
    <td class="sylinfo_e" rowspan="<?= count($value) ?>"><?= htmlspecialchars($name) ?></td>
<?php
    $tr = true;
    foreach ($value as $name1 => $value1) {
        if ($tr) {
            $tr = false;
        } else {
            echo "<tr>";
        }

        if ($name1 == 'args') {
?>
    <td class="sylinfo_e"><?= htmlspecialchars($name1) ?></td>
    <td class="sylinfo_v">
      <table border="0" cellpadding="3" width="100%" class="sylinfo">
<?php   foreach ($value1 as $name2 => $value2) { ?>
        <tr>
          <td class="sylinfo_e"><?= htmlspecialchars($name2) ?></td>
          <td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value2) ?></td>
        </tr>
<?php   } // end foreach ?>
      </table>
    </td>
  </tr>
<?php } else { ?>
    <td class="sylinfo_e"><?= htmlspecialchars($name1) ?></td>
    <td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value1) ?></td>
  </tr>
<?php
      }
  }
}
?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// CONSTANT
// =========================================================
if (!$display || in_array('CONSTANT', $display)) {
?>
<h2>CONSTANT</h2>
<hr class="sylinfo">
<?php
  $skip = true;
  $syl_action  = array();
  $syl_dir     = array();
  $syl_encode  = array();
  $syl_error   = array();
  $syl_log     = array();
  $syl_mail    = array();
  $syl_router  = array();
  $syl_session = array();
  $syl_smarty  = array();
  $syl_other   = array();
  foreach (get_defined_constants() as $name => $value) {
    if ($name == 'SYL_VERSION') {
        $skip = false;
    }
    if ($skip) continue;
    foreach ($not_display_const as $tmp) {
        if (strpos($name, $tmp) !== false) continue 2;
    }

    if (preg_match('/^SYL_ACTION/', $name)) {
        $syl_action[$name] = $value;
    } else if (preg_match('/SMARTY_/', $name)) {
        $syl_smarty[$name] = $value;
    } else if (preg_match('/_DIR$/', $name)) {
        $syl_dir[$name] = $value;
    } else if (preg_match('/^SYL_ENCODE_/', $name)) {
        $syl_encode[$name] = $value;
    } else if (preg_match('/^SYL_ERROR/', $name)) {
        $syl_error[$name] = $value;
    } else if (preg_match('/^SYL_LOG/', $name)) {
        $syl_log[$name] = $value;
    } else if (preg_match('/^SYL_MAIL/', $name)) {
        $syl_mail[$name] = $value;
    } else if (preg_match('/^SYL_ROUTER_/', $name)) {
        $syl_router[$name] = $value;
    } else if (preg_match('/^SYL_SESSION_/', $name)) {
        $syl_session[$name] = $value;
    } else {
        $syl_other[$name] = $value;
    }
  }
?>

<h2>- ACTION -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_action as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- DIRECTORY -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_dir as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- ENCODE -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_encode as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- ERROR -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_error as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- LOG -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_log as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- MAIL -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_mail as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- ROUTER -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_router as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- SESSION -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_session as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- SMARTY -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_smarty as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />

<h2>- OTHER -</h2>

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach ($syl_other as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// INCLUDE
// =========================================================
if (!$display || in_array('INCLUDE', $display)) {
?>
<h2>INCLUDE</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php foreach (get_included_files() as $name => $value) { ?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// FUNCTION
// =========================================================
if (!$display || in_array('FUNCTION', $display)) {
?>
<h2>FUNCTION</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php
  $function_list = get_defined_functions();
  if (isset($function_list['user'])) { foreach ($function_list['user'] as $name => $value) {
?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } } ?>
</table>
<br />
<?php } ?>


<?php
// =========================================================
// CLASS
// =========================================================
if (!$display || in_array('CLASS', $display)) {
?>
<h2>CLASS</h2>
<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr><th class="sylinfo_h">Name</th><th class="sylinfo_h">Value</th></tr>
<?php
  $skip = true;
  foreach (get_declared_classes() as $name => $value) {
    if (strtolower($value) == 'syl_controller') {
        $skip = false;
    }
    if ($skip) continue;
?>
<tr><td class="sylinfo_e"><?= htmlspecialchars($name) ?></td><td class="sylinfo_v"><?= SyL_UtilInfo::formatValue($value) ?></td></tr>
<?php } ?>
</table>
<br />
<?php } ?>

<br />

<table border="0" cellpadding="3" width="600" class="sylinfo">
<tr>
<td style="text-align: right;">SyL Framework v<?= SYL_VERSION ?>, Copyright (c) 2006-2007 k.watanabe&nbsp;&nbsp;</td>
</tr>
</table><br />

<hr class="sylinfo">
</center>

<?php if ($format) { ?>
</body>
</html>
<?php } ?>

<?php
    }
}
?>
