<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB.php,v 1.9 2007/02/22 12:55:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DB.php,v 1.9 2007/02/22 12:55:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DB
{
    /**
     * 󥹥DB̾
     * 
     * @access protected
     * @var string
     */
    var $dbname = '';
    /**
     * ͥ꥽ or ֥
     * 
     * @access protected
     * @var mixed
     */
    var $connection = null;
    /**
     * ȥ󥶥ե饰
     * 
     * @access protected
     * @var boolean
     */
    var $transaction = false;
    /**
     * DB饤ȥ󥳡
     * PHPȤƤʸ̾
     * 
     * @access protected
     * @var string
     */
    var $client_encode = '';
    /**
     * PHP󥳡
     * 
     * @access protected
     * @var string
     */
    var $server_encode = '';
    /**
     * 󥳡Ѵơ֥
     * 
     * @access protected
     * @var string
     */
    var $encode_table = array();

    /**
     * ե򻲾Ȥ
     * ե̾ʸʸ컲ȥե饰
     *
     * @access protected
     * @var string ʸ: CASE_UPPER
     *             ʸ: CASE_LOWER
     *             Τޤ  : ʶʸ
     */
    var $field_case = CASE_UPPER;

    /**
     * tigger_errorȯե饰
     * 
     * @access protected
     * @var bool
     */
    var $trigger_error_flag = true;
    /**
     * ǽ顼
     * 
     * @access protected
     * @var string
     */
    var $last_error_code = '0';
    /**
     * ǽ顼å
     * 
     * @access protected
     * @var string
     */
    var $last_error_message = '';
    /**
     * Хå᥽å
     * 
     * @access protected
     * @var mixed
     */
    var $callback_log = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string Db
     * @param string 饤ȥ󥳡
     * @param string С󥳡
     */
    function SyL_DB($dbtype)
    {
        set_magic_quotes_runtime(0);
        $this->dbname = $dbtype;
    }

    /**
     * SyL_DB饹Υ󥹥󥹼
     *
     * ˡ
     *   $conn =& SyL_DB::getConnection();
     *
     * $dsn = '[dbtype]:dbname=[dbname];host=[hostname];port=[port];user=[username];passwd=[password];client_encode=[client_encode];persistent=[persistent]';
     *
     * PDOξdbtype
     *   pdo.mysql
     *
     * @access public
     * @param string ³ʸ
     */
    function &getConnection($dsn='', $server_encode='')
    {
        static $singleton = array();
        if (!$dsn) {
            if (!count($singleton)) {
                trigger_error("[SyL error] Dsn not found.", E_USER_ERROR);
            }
            return current($singleton);
        }

        if (!isset($singleton[$dsn]) || !is_object($singleton[$dsn])) {
            $tmp  = explode(':', $dsn, 2);
            $type = ucfirst($tmp[0]);
            $dbtype = $dbname = $user = $passwd = $host = $port = $persistent = $client_encode = '';
            if (isset($tmp[1])) {
                $tmp = explode(';', $tmp[1]);
                foreach ($tmp as $tmp2) {
                    list($name, $value) = explode('=', $tmp2, 2);
                    $$name = $value;
                }
            }

            if (!$dbtype) {
                $dbtype = $type;
            }

            $class_name = 'SyL_DB' . $type;

            // ¥󥹥󥹺
            include_once dirname(__FILE__) . "/DB/{$class_name}.php";
            $singleton[$dsn] = new $class_name($dbtype);
            if ($server_encode) $singleton[$dsn]->server_encode = $server_encode;
            if ($client_encode) $singleton[$dsn]->client_encode = $client_encode;
            if (!$singleton[$dsn]->openConnection($dbname, $user, $passwd, $host, $port, $persistent)) {
                $singleton[$dsn] = null;
            } else {
                if ($client_encode) {
                    $singleton[$dsn]->setClientEncoding($client_encode);
                }
            }
        }
        return $singleton[$dsn];
    }

    /**
     * DB³¹
     * 
     * @access protected
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param string ³Ū³Ԥ
     @ @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        trigger_error("[SyL error] openConnection method not found ({$dbname})", E_USER_ERROR);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection() {}

    /**
     * DB饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    function setClientEncoding($client_encode, $server_encode='')
    {
        $client_encode = strtolower($client_encode);
        foreach ($this->encode_table as $encode_table) {
            if ($encode_table[1] == $client_encode) {
                $client_encode = $encode_table[0];
                break;
            }
        }
        $this->client_encode = $client_encode;

        if ($server_encode) {
            $this->server_encode = $server_encode;
        }
    }
  
    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return !is_numeric($parameter) ? addslashes($parameter) : $parameter;
    }

    /**
     * ѥ᡼˥̵˽Likeʸ
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escapeLike($parameter)
    {
        return preg_replace('/(\_|\%)/', '\\\\$1', $this->escape($parameter));
    }

    /**
     * ѥ᡼ͤˤꥯȤʸ
     * ˥¹Ԥ
     *
     * @access public
     * @param string ʸ
     * @return string ȸʸ
     */
    function quote($value)
    {
        if (($value === '') || ($value === null)) {
            return 'NULL';
        } else if (is_int($value) || is_float($value)) {
            return $value;
        } else {
            return "'" . $this->escape($value) . "'";
        }
    }

    /**
     * SQLʸ
     * ˥¹Ԥ
     *
     * @access public
     * @param string ̾
     * @param string ǡ
     * @return string SQLʸ
     */
    function condition($column, $value)
    {
        $value = $this->quote($value);
        if ($value == 'NULL') {
            return "$column IS $value ";
        } else {
            return "$column = $value ";
        }
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        // SQL¸
        $this->log('begin');
  
        if (class_exists('SyL_Error')) {
            $e =& SyL_Error::getInstance();
            $e->resetErrorHandler();
        }
        $this->transaction = true;
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        // SQL¸
        $this->log('rollback');

        if (class_exists('SyL_Error')) {
            $e =& SyL_Error::getInstance();
            $e->setErrorHandler();
        }
        $this->transaction = false;
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
      // SQL¸
      $this->log('commit');

      if (class_exists('SyL_Error')) {
          $e =& SyL_Error::getInstance();
          $e->setErrorHandler();
      }
      $this->transaction = false;
  }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execRef($sql, &$result)
    {
        // SQL¸
        $this->log($sql);

        // ᥽å̾
        list($method) = explode(' ', $sql, 2);

        // SQL¹
        $result = false;
        switch (strtolower($method)) {
        case 'select': $result = $this->execSelect($sql); break;
        case 'insert':
        case 'update':
        case 'delete': $result = $this->execUpdate($sql); break;
        default:       $result = $this->execNoReturn($sql); break;
        }
        return ($result !== false);
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹Է̷ޤDB꥽
     */
    function exec($sql)
    {
        $this->execRef($sql, $result);
        return $result;
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access protected
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        trigger_error("[SyL error] execSelect method not found ({$dbname})", E_USER_ERROR);
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access protected
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        trigger_error("[SyL error] execUpdate method not found ({$dbname})", E_USER_ERROR);
    }

    /**
     * SQL¹ԤΤ
     *
     * @access protected
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        trigger_error("[SyL error] execNoReturn method is not found ({$dbname})", E_USER_ERROR);
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹Է
     */
    function query($sql)
    {
        $this->queryRef($sql, $data, 'all');
        return $data;
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     *
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all') {}

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$page_control, $limit, $page=1) {}

    /**
     * ڡ󥰥֥Ȥ
     *
     * @access public
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return object ڡ󥰥֥
     */
    function &getPager($limit=20, $page=1)
    {
        include_once dirname(__FILE__) . '/SyL_Pager.php';
        $pager = new SyL_Pager();
        $pager->setCount($limit);
        $pager->setPage($page);
        return $pager;
    }

    /**
     * Υѥ᡼ˡSQLDMLˤȤΩƼ¹Ԥ
     * ˥⼫ưǹԤ
     * ѿǻꤹʳϡȽꤵ롣
     *
     * array(
     *  'name'     => $name,
     *  'address'  => $adress,
     *  'datetime' => array('function' => 'current_timestamp'),
     *  'id'       => array('number' => 1),
     *  'IS_NULL'  => array('null' => ''),
     *  ...
     * );
     *
     * @access public
     * @param string ơ֥̾
     * @param array ȤΥǡ
     * @param string insert or update or delete
     * @param string ѥ᡼update, deleteΤߡ
     * @return bool ¹Է true: OKfalse: 顼
     */
    function execPerform($table, $columns, $action='insert', $where='')
    {
        switch (strtolower($action)) {
        case 'insert':
            $field = array();
            $data  = array();
            foreach ($columns as $column => $value) {
                $field[] = $column;
                if (is_array($value)) {
                    list($attribute, $value) = each($value);
                    if ((strtolower($attribute) === 'null') || ($value === null) || ($value === '')) {
                        $data[] = "NULL";
                    } else {
                        switch (strtolower($attribute)) {
                        case 'function':
                        case 'number':
                            $data[] = $value;
                            break;
                        default:
                            $data[] = $this->quote($value);
                            break;
                        }
                    }
                } else {
                    $data[] = $this->quote($value);
                }
            }
            // SQL INSERT
            $sql = "INSERT INTO " . $table . " (" . implode(',', $field) . ") VALUES (" . implode(',', $data) . ")";
            break;

        case 'update':
            $update = array();
            foreach ($columns as $column => $value) {
                if (is_array($value)) {
                    list($attribute, $value) = each($value);
                    if ((strtolower($attribute) === 'null') || ($value === null) || ($value === '')) {
                        $update[] = $column . " = NULL";
                    } else {
                        switch (strtolower($attribute)) {
                        case 'function':
                        case 'number':
                            $update[] = $column . " = " . $value;
                            break;
                        default:
                            $update[] = $column . " = " . $this->quote($value);
                            break;
                        }
                    }
                } else {
                    $update[] = $column . " = " . $this->quote($value);
                }
            }
      
            if ($where != '') {
                $where = "WHERE " . $where;
            }
            // SQL UPDATE
            $sql = "UPDATE " . $table . " SET " . implode(',', $update) . " " . $where;
            break;

        case 'delete':
            if ($where != '') {
                $where = "WHERE " . $where;
            }
            // SQL DELETE
            $sql = "DELETE FROM " . $table . " " . $where;

        default:
          trigger_error("[SyL error] queryPerform method is insert or update or delete only", E_USER_ERROR);
        }

        return $this->exec($sql);
    }

    /**
     * Ǹ줿Ԥ ID 뤤ϥ󥹤ͤ
     *
     * ѤǤʤDBfalse֤
     *
     * @access public
     * @param string ̾
     * @return int Ǹ줿ԤID
     */
    function lastInsertId($seq='')
    {
        return false;
    }

    /**
     * ȥꥬ顼ưǵưʤ褦
     *
     * @access public
     * @param boolean true: ȥꥬ顼ONfalse: ȥꥬ顼OFF
     */
    function setTriggerError($trigger_error_flag)
    {
        $this->trigger_error_flag = ($trigger_error_flag === true);
    }

    /**
     * trigger_errorȯư
     * ȥ󥶥ȯưʤ
     *
     * @access public
     */
    function triggerError()
    {
        if (!$this->transaction && $this->trigger_error_flag) {
            trigger_error($this->getErrorMessage(), E_USER_ERROR);
        }
    }

    /**
     * 顼Ƚ
     *
     * @access public
     * @return bool true: 顼ꡢfalse: 顼̵
     */
    function isError()
    {
        return ($this->last_error_code != '0');
    }

    /**
     * Ǹ˵ä顼ɤ
     *
     * @access public
     * @return string Ǹ˵ä顼
     */
    function errorCode()
    {
        return $this->last_error_code;
    }

    /**
     * Ǹ˵ä顼å
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function errorInfo()
    {
        return $this->last_error_message;
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        $this->last_error_code    = $code;
        $this->last_error_message = $message;
    }

    /**
     * Ǹ˵ä顼å
     *
     * 顼Ƥʤϡ''
     *
     * @access public
     * @return string Ǹ˵ä顼å
     */
    function getErrorMessage()
    {
        if ($this->errorInfo()) {
            return $error_message = "[SyL DB Error " . $this->errorCode() . "] " . $this->errorInfo();
        } else {
            return '';
        }
    }

    /**
     * ̥åΥե̾ʸޤϾʸȤˤ
     *
     * @access public
     * @param array Ѵ
     * @return array Ѵ
     */
    function caseFieldName($record)
    {
        if (is_array($record) && $this->field_case) {
            return array_change_key_case($record, $this->field_case);
        } else {
            return $record;
        }
    }

    /**
     * 󥳡ѴPHP => DBˤԤ
     *
     * (1) set names sjis
     *    db     ?
     *    client sjis
     *    view   sjis
     * (2) convertEncoding
     *    encode
     *    db     ?
     *    client sjis  mb_convert_encoding($value, ?, 'sjis');
     *    view   sjis
     *    decode
     *    db     ?
     *    client sjis  mb_convert_encoding($value, 'sjis', ?);
     *    view   sjis
     * @access public
     * @param mixed Ѵ
     * @return mixed Ѵ
     */
    function convertEncoding(&$value)
    {
        if ($this->client_encode && $this->server_encode) {
            if (is_array($value)) {
                foreach ($value as $key => $value2) {
                    $this->convertEncoding($value[$key]);
                }
            } else {
                $value = mb_convert_encoding($value, $this->server_encode, $this->client_encode);
            }
        }
    }

    /**
     * ǥѴDB => PHPˤԤ
     *
     * @access public
     * @param mixed Ѵ
     * @return mixed Ѵ
     */
    function convertDecoding(&$value)
    {
        if ($this->client_encode && $this->server_encode) {
            if (is_array($value)) {
                foreach ($value as $key => $value2) {
                    $this->convertDecoding($value[$key]);
                }
            } else {
                $value = mb_convert_encoding($value, $this->client_encode, $this->server_encode);
            }
        }
    }

    /**
     * Хå᥽åɤ򥻥å
     *
     * @access public
     * @param mixed Хå᥽å
     */
    function setCallbackLog($callback_log)
    {
        if (is_callable($callback_log)) {
            $this->callback_log = $callback_log;
        } else {
            trigger_error("[SyL error] setCallbackLog argument invalid function (" . print_r($callback_log, true) . ")");
        }
    }

    /**
     * ꥸʥ꥽ޤϥ֥Ȥ
     *
     * @access public
     * @return mixed ꥸʥ꥽ޤϥ֥
     */
    function &getResource()
    {
        return $this->connection;
    }

    /**
     * SQL¸
     *
     * @access public
     * @param string SQLʸ
     */
    function log($sql)
    {
        if ($this->callback_log != null) {
            call_user_func($this->callback_log, $sql);
        }
    }
}

?>
