<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorCompare.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Ӹڥ饹
 * 
 * ˡ== 
 * $SyL_Validator =& SyL_Validator::create( 'compare', '{name}ɬܤǤ', array( 'compare' => '==', 'value' => 'aaa' );
 *
 * ˡ> 
 * $SyL_Validator =& SyL_Validator::create( 'compare', '{name}ɬܤǤ', array( 'compare' => '>', 'value' => '13' );
 *
 * 顼åѴʸ
 *  {value} : 
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorCompare.php,v 1.1 2007/03/31 08:45:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorCompare extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'compare' => '==',
      'value'   => null
    );

    /**
     * Ӹڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        $target  = $this->parameters['value'];
        $compare = $this->parameters['compare'];
  
        if (preg_match( '/^(!=|==)$/', $compare)) {
            return eval( 'return ("' . $value . '" ' . $compare . ' "' . $target . '");' );
        } else if (preg_match( '/^(<=|>=|>|<)$/', $compare)) {
            return eval( 'return (floatval("' . $value . '") ' . $compare . ' floatval("' . $target . '"));' );
        } else {
            return false;
        }
    }

    /**
     * ӸڽJavaScript
     *
     * @access public
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJavaScript($parts)
    {
        $target  = $this->parameters['value'];
        $compare = $this->parameters['compare'];

        $js  = "";
        $js .= "if (!error_flag && !validator.isCompare(element_name, '" . $this->getErrorMessage() . "', '{$target}', '{$compare}')) { \r\n";
        $js .= "  error_flag = true; \r\n";
        $js .= "} \r\n";
        return $js;
    }
}

?>
