<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementSelect.php,v 1.9 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ץեǥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementSelect.php,v 1.9 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FormElementSelect extends SyL_FormElement
{
    /**
     * Ǵ֤ζڤʸ
     *
     * @access private
     * @var string
     */
    var $separator = "&nbsp;\r\n";

    /**
     * ̾ʣˤ
     *
     * @access public
     * @return string ̾
     */
    function getNames()
    {
        return $this->getName() . '[]';
    }

    /**
     * ͤ򥻥åȤ
     *
     * @access public
     * @param mixed 
     */
    function setValue($value)
    {
        if (($value === '') || ($value === null)) {
            $this->value = array();
        } else if (!is_array($value)) {
            $this->value = array($value);
        } else {
            $this->value = $value;
        }
    }

    /**
     * Ǵ֤ζڤʸ򥻥å
     *
     * @access public
     * @param string Ǵ֤ζڤʸ
     */
    function setSeparator($separetor)
    {
        $this->separator = $separetor;
    }

    /**
     * եHTMLϡϹܡ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlTag()
    {
        $this->setAttribute($this->getNames(), 'name');

        $options = array();
        foreach ($this->options as $key => $value) {
            $selected = in_array((string)$key, $this->value, true) ? ' selected' : '';
            $options[] = '<option value="' . $key . '" ' . $selected . '>' . $this->encode($value) . '</option>';
        }

        $html_element  = '';
        $html_element .= '<select ' . $this->getAttributes() . '>';
        $html_element .= implode("\r\n", $options);
        $html_element .= '</select>';

        return $html_element;
    }

    /**
     * եHTMLϡɽ
     *
     * @access public
     * @return string եǤHTML
     */
    function getHtmlView()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if (in_array((string)$key, $this->value, true)) {
                $options[] = $this->encode($value) . $this->getHtmlHidden($this->getNames(), $key);
            }
        }
        return implode($this->separator, $options);
    }

    /**
     * JavaScriptϥå
     * С饤
     *
     * @access public
     * @return string JavaScriptϥå
     */
    function getJs()
    {
        if (is_object($this->validators)) {
            $js  = '';
            $js .= 'var error_flag = false;' . "\n";
            $js .= 'var element_name = "' . $this->getNames() . '";' . "\n";
            $js .= $this->validators->getJs($this->getDisplayName(), $this->options);
            $js .= "\n";
            return $js;
        } else {
            return '';
        }
    }
}

?>
