<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfigXml.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML꡼饹
 */
require_once dirname(__FILE__) . '/../../Xml/SyL_XmlReader.php';

/**
 * XMLꥯ饹
 * 
 * ե
 *
 * ...
 * <validations>
 *   <validation name="def1" displayName="̾">
 *     <validator name="require" errorMessage="{name}ɬܤǤ">
 *       <option name="max" value="19" />
 *       <option name="min" value="1" />
 *     </validator>
 *     <validator name="require" errorMessage="{name}ɬܤǤ">
 *       <option name="max" value="19" />
 *       <option name="min" value="1" />
 *     </validator>
 *   </validation>
 *   ...
 * </validations>
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfigXml.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationConfigXml extends SyL_ValidationConfig
{
    /**
     * ѡ
     *
     * @access protected
     */
    function parse()
    {
        $reader =& new SyL_ValidationConfigXmlReader();
        $reader->setFile($this->filename);
        $reader->parseXml();
        $this->config = $reader->getConfig();
        $this->config_name = $reader->getConfigName();
    }
}


/**
 * XMLɤ߹ߥ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationConfigXml.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationConfigXmlReader extends SyL_XmlReader
{
    /**
     * 
     *
     * @access protected
     * @var array
     */
    var $config = array();
    /**
     * ̾
     *
     * @access protected
     * @var array
     */
    var $config_name = array();

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $validation = '';

        // XMLϷ̤
        switch ($current_path) {
        case '/validations/validation':
            $validation = $attribute['name'];
            $this->config[$validation]      = array();
            $this->config_name[$validation] = isset($attribute['displayName']) ? $attribute['displayName'] : '';
            $i = -1;
            break;
        case '/validations/validation/validator':
            $i++;
            $this->config[$validation][$i]['validator']    = $attribute['name'];
            $this->config[$validation][$i]['errorMessage'] = $attribute['errorMessage'];
            break;
        case '/validations/validation/validator/option':
            $this->config[$validation][$i]['options'][$attribute['name']] = $attribute['value'];
            break;
        }
    }

    /**
     * XMLͤ
     * 
     * @return array 
     */
    function getConfig()
    {
        return $this->config;
    }

    /**
     * XMLͤ̾
     * 
     * @return array ̾
     */
    function getConfigName()
    {
        return $this->config_name;
    }
}

?>
