<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcBuilder.php,v 1.1 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once dirname(__FILE__) . '/../../Util/SyL_UtilParameter.php';

/**
 * XML饹
 */
require_once dirname(__FILE__) . '/../SyL_XmlWriter.php';

/**
 * XMLRPC饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcBuilder.php,v 1.1 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcBuilder extends SyL_UtilParameter
{
    /**
     * 󥳡ǥ
     *
     * @access private
     * @var string
     */
    var $encoding = 'UTF-8';

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼
     * @param string 
     */
    function set($value, $format='')
    {
        static $i = 0;
        $format = $i++ . ':' . $format;
        parent::set($format, $value);
    }

    /**
     * XMLRPC󥳡ǥ󥰤򥻥å
     * 
     * @access public
     * @param string XMLRPC󥳡ǥ
     */
    function setEncoding($encoding)
    {
        $this->encoding = $encoding;
    }

    /**
     * եޥåȤѴ
     * 
     * @access protected
     * @param string ѥ᡼
     * @param string 
     * @return string Ѵ巿
     */
    function encodeFormat($value, $format)
    {
        switch (strtolower($format)) {
        case 'string':  return 'string';
        case 'int':
        case 'i4':
        case 'number':  return 'int';
        case 'bool':
        case 'boolean': return 'boolean';
        case 'double':
        case 'float':   return 'double';
        case 'datetime':
        case 'datetime.iso8601': return 'dateTime.iso8601';
        case 'base64':
        case 'binary': return 'base64';
        case 'array':  return 'array';
        case 'struct': return 'struct';
        default:
            if ($format) {
                trigger_error("[SyL error] XmlRpc parameter format invalid ({$format})", E_USER_ERROR);
            }
            if (is_array($value)) {
                return ((count($value) == 0) || isset($value[0])) ? 'array' : 'struct';
            } else if (is_object($value)) {
                return 'struct';
            } else if (is_bool($value)) {
                return 'boolean';
            } else if (is_int($value)) {
                return 'int';
            } else if (is_float($value)) {
                return 'double';
            } else {
                return 'string';
            }
        }
    }

    /**
     * ͤѴ
     * 
     * @access protected
     * @param string ѥ᡼
     * @param string 
     * @return mixed Ѵ
     */
    function encodeValue($value, $format)
    {
        switch ($format) {
        case 'struct':
            if (is_object($value)) {
                $values = array();
                foreach (get_object_vars($value) as $k => $v) {
                  $values[$k] = $v;
                }
                $value = $values;
            }
            return $value;
        case 'boolean':
            return ($value ? '1' : '0');
        case 'int':
        case 'double':
            return (string)$value;
        case 'base64':
            return base64_encode($value);
        case 'dateTime.iso8601':
            if (preg_match('/^(\d{4})[\/\-]?(\d{2})[\/\-]?(\d{2})[ ]?(\d{2}):?(\d{2}):?(\d{2})$/', $value, $matches)) {
                $value = $matches[1] . $matches[2] . $matches[3] . 'T' . $matches[4] . ':' . $matches[5] . ':' . $matches[6];
            } else if (preg_match('/^(\d{4})[\/\-]?(\d{2})[\/\-]?(\d{2})$/', $value, $matches)) {
                $value = $matches[1] . $matches[2] . $matches[3] . 'T00:00:00';
            }
            return $value;
        default:
            return $value;
        }
    }

    /**
     * ѥ᡼ꥯȷѴ
     * 
     * @access public
     * @return string XMLǡ
     */
    function build()
    {
        $xml = new SyL_XmlWriter();
        $xml->isEol(true);
        $xml->addDeclaration('1.0', $this->encoding);
        $this->buildXml($xml);
        return $xml->create();
    }

    /**
     * XMLRPC
     * 
     * @access public
     * @param object XML饤֥
     */
    function buildXml(&$xml)
    {
    }

    /**
     * ѥ᡼ƵŪѴ
     * 
     * @access protected
     * @param object XML饤֥
     * @param string ѥ᡼
     * @param string 
     */
    function buildParameter(&$xml, $value, $format='')
    {
        $format = $this->encodeFormat($value, $format);
        $value  = $this->encodeValue($value, $format);
        if ($format == 'array') {
            $xml->addStartElement($format);
            $xml->addStartElement('data');
            foreach ($value as $tmp) {
                $xml->addStartElement('value');
                $this->buildParameter($xml, $tmp);
                $xml->addEndElement();
            }
            $xml->addEndElement();
            $xml->addEndElement();
        } else if ($format == 'struct') {
            $xml->addStartElement($format);
            foreach ($value as $tmp1 => $tmp2) {
                $xml->addStartElement('member');
                $xml->addElement('name', array(), $tmp1);
                $xml->addStartElement('value');
                $this->buildParameter($xml, $tmp2);
                $xml->addEndElement();
                $xml->addEndElement();
            }
            $xml->addEndElement();
        } else {
            $xml->addElement($format, array(), $value);
        }
    }
}

?>
