<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientReader.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML꡼饹
 */
require_once dirname(__FILE__) . '/../SyL_XmlReader.php';

/**
 * XML RPCꥯȷ̥ѡ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientReader.php,v 1.2 2007/04/14 09:59:36 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcClientReader extends SyL_XmlReader
{
    /**
     * 顼Ƚե饰
     * 
     * @access private
     * @var bool
     */
    var $error = false;
    /**
     * 顼
     * 
     * @access private
     * @var int
     */
    var $error_code = 0;
    /**
     * 顼å
     * 
     * @access private
     * @var string
     */
    var $error_message = '';
    /**
     * 
     * 
     * @access private
     * @var mixed
     */
    var $value = null;

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $keys = array();
        static $fault_name = '';

        switch ($current_path) {
        // =============================
        // 顼
        // =============================
        case '/methodResponse/fault':
            $this->error = true;
            break;
        case '/methodResponse/fault/value/struct/member/name':
            $fault_name = $text;
            break;
        case '/methodResponse/fault/value/struct/member/value':
        case '/methodResponse/fault/value/struct/member/value/string':
            if ($text !== null) {
                switch ($fault_name) {
                case 'faultCode':   $this->error_code    = $this->formatValue('string', $text); break;
                case 'faultString': $this->error_message = $this->formatValue('string', $text); break;
                }
            }
            break;
        case '/methodResponse/fault/value/struct/member/value/int':
        case '/methodResponse/fault/value/struct/member/value/i4':
            switch ($fault_name) {
            case 'faultCode':   $this->error_code    = $this->formatValue('int', $text); break;
            case 'faultString': $this->error_message = $this->formatValue('int', $text); break;
            }
            break;

        // =============================
        // 
        // =============================
        case '/methodResponse/params':
            $this->error = false;
            break;

        case '/methodResponse/params/param/value/dateTime.iso8601':
        case '/methodResponse/params/param/value/string':
        case '/methodResponse/params/param/value/base64':
        case '/methodResponse/params/param/value/i4':
        case '/methodResponse/params/param/value/int':
        case '/methodResponse/params/param/value/double':
        case '/methodResponse/params/param/value/boolean':
            $format = substr($current_path, strrpos($current_path, '/') + 1);
            $this->value = $this->formatValue($format, $text);
            break;
        case '/methodResponse/params/param/value/array':
        case '/methodResponse/params/param/value/struct':
            $this->value = array();
            break;
        case '/methodResponse/params/param/value/struct/member/name':
            $keys = array();
            $keys[0] = $text;
            break;

        default:
            if (preg_match('/^\/methodResponse\/params\/param\/value\/(.*)array\/data\/value$/', $current_path)) {
                if ($text !== null) {
                    $i = substr_count($current_path, 'value') - 1;
                    if (!isset($keys[$i])) {
                        $keys[$i] = 0;
                    } else {
                        $keys[$i]++;
                    }
                    $text = $this->formatValue('string', $text);
                    call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));
                }

            } else if (preg_match('/^\/methodResponse\/params\/param\/value\/(.*)array\/data\/value\/(string|i4|int|double|boolean|dateTime\.iso8601|base64)$/', $current_path, $matches)) {
                $i = substr_count($current_path, 'value') - 1;
                if (!isset($keys[$i])) {
                    $keys[$i] = 0;
                } else {
                    $keys[$i]++;
                }
                $format = array_pop($matches);
                $text = $this->formatValue($format, $text);
                call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));

            } else if (preg_match('/^\/methodResponse\/params\/param\/value\/(.*)struct\/member\/name$/', $current_path, $matches)) {
                $i = substr_count($current_path, 'value');
                $keys[$i] = $text;

            } else if (preg_match('/^\/methodResponse\/params\/param\/value\/(.*)struct\/member\/value$/', $current_path, $matches)) {
                if ($text !== null) {
                    $text = $this->formatValue('string', $text);
                    call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));
                }
            } else if (preg_match('/^\/methodResponse\/params\/param\/value\/(.*)struct\/member\/value\/(string|i4|int|double|boolean|dateTime\.iso8601|base64)$/', $current_path, $matches)) {
                $format = array_pop($matches);
                $text = $this->formatValue($format, $text);
                call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));
            }
        }
    }

    /**
     * ѥ᡼ѴƼ
     *
     * @access private
     * @param string 
     * @param string 
     * @return mixed Ѵ
     */
    function formatValue($format, $value)
    {
        switch ($format) {
        case 'i4':
        case 'int':     return (int)$value;
        case 'double':  return (float)$value;
        case 'boolean':
            if (strtolower($value) == 'false') {
                $value = false;
            }
            return (bool)$value;
        case 'base64':
            return base64_decode($value);
        case 'dateTime.iso8601':
            if (preg_match('/^(\d{4})(\d{2})(\d{2})T(\d{2}:\d{2}:\d{2})$/', $value, $matches)) {
                $value = $matches[1] . '/' . $matches[2] . '/' . $matches[3] . ' ' . $matches[4];
            }
        default:
          return (string)$value;
        }
    }

    /**
     * ȤΥͤ
     *
     * @access private
     * @param array 
     */
    function setCurrentValue($value)
    {
        $keys = '';
        foreach (array_slice(func_get_args(), 1) as $key) {
            if (is_int($key)) {
                $keys .= "[{$key}]";
            } else {
                $keys .= "['{$key}']";
            }
        }
        eval('$this->value' . $keys . " = '" . $value . "';");
    }

    /**
     * 顼Ƚ
     *
     * @access public
     * @return bool true: 顼ꡢfalse: 顼ʤ
     */
    function isError()
    {
        return $this->error;
    }

    /**
     * 顼ɤ
     *
     * @access public
     * @return string 顼
     */
    function getErrorCode()
    {
        return $this->error_code;
    }

    /**
     * 顼å
     *
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * XMLRPCͤ
     *
     * @access public
     * @return mixed XMLRPC
     */
    function getValue()
    {
        return $this->value;
    }
}

?>
