<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader1_0.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 1.0꡼饹
 *
 * С̡ݲ
 *
 * [channel]
 *   copyright     <- dc:right
 *   description
 *   language     <- dc:language
 *   link
 *   date        <- dc:date
 *   title
 *   category   <- dc:subject
 *
 * [image]
 *   height  <- (null)
 *   link
 *   title
 *   url
 *   width  <- (null)
 *
 * [textInput]
 *   description
 *   link
 *   name
 *   title
 *
 * [item]
 *   description
 *   link
 *   title
 *   author   <- dc:creator
 *   category <- dc:subject
 *   date     <- dc:date
 *   source   <- dc:source
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader1_0.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssReader1_0 extends SyL_XmlRssReader
{
    /**
     * RSSС
     * 
     * @access private
     * @var string
     */
    var $version = '1.0';

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $rss_item_count = 0;

        // XMLϷ̤
        switch ($current_path) {
        // -------------------------------------------------
        // إå
        // -------------------------------------------------
        case '/rdf:RDF/channel/title':        $this->channel['title']       = $text; break; // ȥ
        case '/rdf:RDF/channel/link':         $this->channel['link']        = $text; break; // 
        case '/rdf:RDF/channel/description':  $this->channel['description'] = $text; break; // 

        case '/rdf:RDF/channel/dc:creator':     $this->channel['dc:creator']     = $text; break;  // ꥽Ǥ
        case '/rdf:RDF/channel/dc:contributor': $this->channel['dc:contributor'] = $text; break; 
        case '/rdf:RDF/channel/dc:coverage':    $this->channel['dc:coverage']    = $text; break; 
        case '/rdf:RDF/channel/dc:date':        $this->channel['date']           = $this->convertDateTime($text); break;  // ꥽κ
        case '/rdf:RDF/channel/dc:description': $this->channel['dc:description'] = $text; break; 
        case '/rdf:RDF/channel/dc:format':      $this->channel['dc:format']      = $text; break; 
        case '/rdf:RDF/channel/dc:identifier':  $this->channel['dc:identifier']  = $text; break; 
        case '/rdf:RDF/channel/dc:language':    $this->channel['language']       = $text; break; // 
        case '/rdf:RDF/channel/dc:publisher':   $this->channel['dc:publisher']   = $text; break; // ꥽Ǥ
        case '/rdf:RDF/channel/dc:relation':    $this->channel['dc:relation']    = $text; break; 
        case '/rdf:RDF/channel/dc:rights':      $this->channel['copyright']      = $text; break; // ԡ饤
        case '/rdf:RDF/channel/dc:source':      $this->channel['dc:source']      = $text; break; 
        case '/rdf:RDF/channel/dc:subject':     $this->channel['category']       = $text; break; // ꥽˴ޤޤ
        case '/rdf:RDF/channel/dc:title':       $this->channel['dc:title']       = $text; break; 
        case '/rdf:RDF/channel/dc:type':        $this->channel['dc:type']        = $text; break; 
        // 
        case '/rdf:RDF/image':
            // ɬ°
            $this->channel['image'] = $this->initImage();
            $this->channel['image']['url'] = $attribute['rdf:about']; // URL
            break;
        case '/rdf:RDF/image/title': $this->channel['image']['title'] = $text; break; // ȥ
        case '/rdf:RDF/image/link':  $this->channel['image']['link']  = $text; break; // 
        // 
        case '/rdf:RDF/textinput':
            // ɬ°
            $this->channel['textinput'] = $this->initTextInput();
            $this->channel['textinput']['url'] = $attribute['rdf:about'];
            break;
        case '/rdf:RDF/textinput/title':       $this->channel['textinput']['title']       = $text; break; // ǥ٥
        case '/rdf:RDF/textinput/name':        $this->channel['textinput']['name']        = $text; break; // ̾
        case '/rdf:RDF/textinput/description': $this->channel['textinput']['description'] = $text; break; // ǥեʸ
        case '/rdf:RDF/textinput/link':        $this->channel['textinput']['link']        = $text; break; // ǥեʸ

        // -------------------------------------------------
        // ǡ
        // -------------------------------------------------
        // RSS
        case '/rdf:RDF/item':
            // ɬ°
            $this->items[] = $this->initItem();
            $rss_item_count = count($this->items);
            break;
        case '/rdf:RDF/item/title':       $this->items[$rss_item_count-1]['title']       = $text; break; // ȥ
        case '/rdf:RDF/item/link':        $this->items[$rss_item_count-1]['link']        = $text; break; // 
        case '/rdf:RDF/item/description': $this->items[$rss_item_count-1]['description'] = $text; break; // 

        case '/rdf:RDF/item/dc:creator':     $this->items[$rss_item_count-1]['author']         = $text; break;  // ꥽Ǥ
        case '/rdf:RDF/item/dc:contributor': $this->items[$rss_item_count-1]['dc:contributor'] = $text; break; 
        case '/rdf:RDF/item/dc:coverage':    $this->items[$rss_item_count-1]['dc:coverage']    = $text; break; 
        case '/rdf:RDF/item/dc:date':        $this->items[$rss_item_count-1]['date']           = $this->convertDateTime($text); break;  // ꥽κ
        case '/rdf:RDF/item/dc:description': $this->items[$rss_item_count-1]['dc:description'] = $text; break; 
        case '/rdf:RDF/item/dc:format':      $this->items[$rss_item_count-1]['dc:format']      = $text; break; 
        case '/rdf:RDF/item/dc:identifier':  $this->items[$rss_item_count-1]['dc:identifier']  = $text; break; 
        case '/rdf:RDF/item/dc:language':    $this->items[$rss_item_count-1]['dc:language']    = $text; break; // 
        case '/rdf:RDF/item/dc:publisher':   $this->items[$rss_item_count-1]['dc:publisher']   = $text; break; // ꥽Ǥ
        case '/rdf:RDF/item/dc:relation':    $this->items[$rss_item_count-1]['dc:relation']    = $text; break; 
        case '/rdf:RDF/item/dc:rights':      $this->items[$rss_item_count-1]['dc:rights']      = $text; break; // ԡ饤
        case '/rdf:RDF/item/dc:source':      $this->items[$rss_item_count-1]['source']         = $text; break; 
        case '/rdf:RDF/item/dc:subject':     $this->items[$rss_item_count-1]['category']       = $text; break; // ꥽˴ޤޤ
        case '/rdf:RDF/item/dc:title':       $this->items[$rss_item_count-1]['dc:title']       = $text; break; 
        case '/rdf:RDF/item/dc:type':        $this->items[$rss_item_count-1]['dc:type']        = $text; break; 
        }
    }
}

?>
