<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.12 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹ߡ륯饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.12 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigDefines extends SyL_Config
{
    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_WEBAPP_CACHE_DIR) {
            // åѤ
            $key = implode('', $this->file_names);
            $cache =& SyL_Cache::getObject($key, 'fileupdate');
            $cache->setCacheDir(SYL_WEBAPP_CACHE_DIR . '/defines');
            $this->config = $cache->read($this->file_names);
            if (!$this->config) {
                parent::parseXml();
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXml();
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access public
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        if ($current_path == '/syl-defines/define') {
            $this->config[$attribute['name']] = $text;
        }
    }

}

?>
