<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestSession.php,v 1.8 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Util/SyL_UtilProperty.php';

/**
 * åݻ饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestSession.php,v 1.8 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RequestSession extends SyL_UtilProperty
{
    /**
     * åURLѥ
     *
     * @access private
     * @var string
     */
    var $path = '';
    /**
     * å󳫻ϥե饰
     *
     * @access private
     * @var bool
     */
    var $start = false;

    /**
     * DBå󥪥֥
     *
     * @access private
     * @var object
     */
    var $session_db = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RequestSession()
    {
        if (!$this->start) {
            // å̾򥻥å
            if (SYL_SESSION_NAME) {
                session_name(SYL_SESSION_NAME);
            }
            // åѹ
            if (SYL_SESSION_CACHE) {
                session_cache_limiter(SYL_SESSION_CACHE);
            }

            // åƼѥ᡼
            $this->path     = SYL_SESSION_PATH   ? SYL_SESSION_PATH   : '/';
            $session_domain = SYL_SESSION_DOMAIN ? SYL_SESSION_DOMAIN : null;
            $session_secure = SYL_SESSION_SECURE ? true : false;
            session_set_cookie_params(0, $this->path, $session_domain, $session_secure);

            if (strtolower(SYL_SESSION_TYPE) == 'db') {
                // DBå
                include_once SYL_INCLUDE_DIR . '/framework/RequestParameter/SyL_SessionDB.php';
                $this->session_db =& new SyL_SessionDB();
            }

            // å󳫻
            $this->startSession();
            // åIDѹ
            if (SYL_SESSION_REGENERATE) {
                $this->regenerateSession();
            }
        }
    }

    /**
     * å򳫻Ϥ
     *
     * @access public
     */
    function startSession($old_session_data=null)
    {
        if (!$this->start) {
            session_start();
            $this->start = true;
            if (is_array($old_session_data)) {
                $_SESSION = $old_session_data;
            }
            $this->parameters =& $_SESSION;
        }
    }

    /**
     * å󤬳ϤƤ뤫Ƚ
     *
     * @access public
     * @return true: ϤƤ롢false: ϤƤʤ
     */
    function isSession()
    {
        return $this->start;
    }

    /**
     * åIDѹ
     * å󳫻ϸ˼¹Ԥ
     *
     * @access public
     */
    function regenerateSession()
    {
        if (version_compare(PHP_VERSION, '5.1.0', '>=')) {
            session_regenerate_id(true);
        } else {
            $old_session_id   = $this->getSessionId();
            $old_session_data = $this->parameters;
            $_SESSION = array();
            session_destroy();
            $this->start = false;

            $session_dir = session_save_path();
            $new_session_id = '';
            do {
              $new_session_id = md5(uniqid(rand(), true));
            } while (file_exists("{$session_dir}/sess_{$new_session_id}"));
            session_id($new_session_id);

            $this->startSession($old_session_data);
        }
    }

    /**
     * ѥ᡼
     * 
     * @access public
     */
    function deletes()
    {
        parent::deletes();
        if (isset($_COOKIE[session_name()])) {
           setcookie(session_name(), '', time()-42000, $this->path);
        }
        session_destroy();
        $this->start = false;
    }

    /**
     * åͤ¸λ
     * 
     * @access public
     * @param array ѥ᡼
     */
    function writeCloseSession($values)
    {
        $this->startSession();
        parent::sets($values);
        $this->closeSession();
    }

    /**
     * åλ
     * 
     * @access public
     */
    function closeSession()
    {
        if ($this->start) {
            session_write_close();
            $this->start = false;
            parent::deletes();

            // 2ܰʹߤsession_start()ǥåȯԤʤб
            if (ini_get('session.use_cookies')) {
              ini_set('session.use_cookies', '0');
            }
        }
    }

    /**
     * åID
     * 
     * @access public
     * @return mixed åID
     */
    function getSessionId()
    {
        return session_id();
    }

    /**
     * ѥ᡼̾եåID
     * 
     * @access public
     * @return string ѥ᡼̾եåID
     */
    function getSidQuery()
    {
        return session_name() . '=' . $this->getSessionId();
    }
}

?>
