<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validation.php,v 1.11 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڸ̥饹
 */
require_once dirname(__FILE__) . '/Validation/SyL_ValidationValidator.php';
/**
 * ڸ̥롼ץ饹
 */
require_once dirname(__FILE__) . '/Validation/SyL_ValidationValidators.php';

/**
 * ڥ饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validation.php,v 1.11 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Validation
{
    /**
     * 顼å
     *
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * 顼å
     *
     * @access public
     * @param string ̾
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * 顼å
     *
     * @access public
     * @param string ̾
     */
    function replaceErrorMessage($name)
    {
        if ($name) {
            $this->error_message = str_replace(array('{name}', '%name%'), $name, $this->error_message);
        }
    }

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @param string о̾
     * @return bool true: 顼̵, false: 顼
     */
    function execute($value, $name='')
    {
    }

    /**
     * ɬܥå¸Ƚ
     *
     * @access public
     * @return bool true: ɬܥåꡢfalse: ɬܥå̵
     */
    function isRequire()
    {
        return preg_match('/^SyL_ValidationValidatorRequire(.*)$/i', get_class($this));
    }

    /**
     * JavaScriptå
     *
     * @access public
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @return string JavaScriptå
     */
    function getJs($display_name)
    {
        return '';
    }
}

?>
