<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationManager.php,v 1.11 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڥ饹
 */
require_once 'SyL_Validation.php';

/**
 * ڥץ饹
 * 
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationManager.php,v 1.11 2007/04/24 16:49:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationManager
{
    /**
     * ڥ饹ޤȤ᤿
     *
     * @access private
     * @var array
     */
    var $validators = array();

    /**
     * ꥪ֥Ȥ
     *
     * @access public
     * @param string ե̾
     * @param string եĥ
     */
    function &getConfig($filename, $ext='')
    {
        include_once dirname(__FILE__) . '/Validation/SyL_ValidationConfig.php';
        $config =& SyL_ValidationConfig::getConfig($filename, $ext);
        return $config;
    }

    /**
     * ڥ֥Ȥɲä
     *
     * @access public
     * @param object ڥ֥
     * @param string ڹ
     * @param string ̾
     * @param string ڹ̾
     */
    function add(&$validator, $value, $element_name='', $name='')
    {
        if ($element_name == '') {
            $element_name = $this->getDefaultElementName();
        }

        $this->validators[$element_name] = array(
          'name'          => $name,
          'value'         => $value,
          'error_massage' => ''
        );

        if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
            $this->validators[$element_name]['validator'] = unserialize(serialize($validator));
        } else {
            $this->validators[$element_name]['validator'] = $validator;
        }
    }

    /**
     * ڳ顼򥻥åȤ
     *
     * @access public
     * @param string 顼å
     * @param string ̾
     */
    function addError($error_massage, $element_name='')
    {
        if ($element_name == '') {
            $element_name = $this->getDefaultElementName();
        }
        $this->validators[$element_name] = array(
          'name'          => '',
          'value'         => '',
          'validator'     => null,
          'error_massage' => $error_massage
        );
    }

    /**
     * ǥեȤ̾
     *
     * @access public
     * @return string ̾
     */
    function getDefaultElementName()
    {
        static $i = 1;
        $element_name = __CLASS__ . $i++;
        return $element_name;
    }

    /**
     * ͤ鸡ڤ¹Ԥ
     *
     * @access public
     * @param object ֥ͥ
     * @param array ͼ
     * @return bool true: 顼̵, false: 顼
     */
    function executeConfig(&$config, $resource=null)
    {
        if ($resource === null) {
            $resource = ($_SERVER['REQUEST_METHOD'] == 'POST') ? $_POST + $_GET : $_GET + $_POST;
        }
        if (!is_array($resource)) {
            trigger_error("[SyL error] Invalid executeConfig method arg. Array only", E_USER_ERROR);
        }
        foreach ($config->getKeys() as $key) {
            $validators   =& $config->get($key);
            $display_name =  $config->getName($key);
            $value = isset($resource[$key]) ? $resource[$key] : null;
            $this->add($validators, $value, $key, $display_name);
        }
        return $this->execute();
    }

    /**
     * ڽ¹Ԥ
     *
     * @access public
     * @return bool true: 顼̵, false: 顼
     */
    function execute()
    {
        $valid = true;
        foreach (array_keys($this->validators) as $key) {
            if ($this->validators[$key]['validator'] != null) {
                if (!$this->validators[$key]['validator']->execute($this->validators[$key]['value'], $this->validators[$key]['name'])) {
                    $this->validators[$key]['error_massage'] = $this->validators[$key]['validator']->getErrorMessage();
                    $valid = false;
                }
            }
        }
        return $valid;
    }

    /**
     * ΤޤϹܤȤ˥顼뤫Ƚꤹ
     *
     * @access public
     * @param string ̾
     * @return bool true: 顼ꡢfalse: 顼ʤ
     */
    function isError($element_name='')
    {
        if ($element_name != '') {
            return (isset($this->validators[$element_name]) && ($this->validators[$element_name]['error_massage'] != ''));
        } else {
            foreach (array_keys($this->validators) as $key) {
                if ($this->validators[$key]['error_massage'] != '') {
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * ΤޤϹܤȤ˥顼å
     *
     * @access public
     * @param string ̾
     * @return string 顼å
     */
    function getErrorMessage($element_name)
    {
        return (isset($this->validators[$element_name]) ? $this->validators[$element_name]['error_massage'] : '');
    }

    /**
     * 顼å
     *
     * @access public
     * @return array 顼å
     */
    function getErrorMessageAll()
    {
        $error_message = array();
        foreach (array_keys($this->validators) as $key) {
            if ($this->validators[$key]['error_massage'] != '') {
                $error_message[] = $this->validators[$key]['error_massage'];
            }
        }
        return $error_message;
    }
}

?>
