<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.3 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܾ󥯥饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Router.php';

/**
 * ե졼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.3 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Context
{
    /**
     * ѥ᡼
     * 
     * @access private
     * @var string
     */
    var $parameters = array();
    /**
     * ӥ塼ѥ᡼
     * 
     * @access private
     * @var array
     */
    var $view_parameters = array();
    /**
     * ե륿󥿡ե᥽å̾
     * 
     * @access private
     * @var string
     */
    var $filter_method = 'affect';
    /**
     * ӥ塼
     * 
     * @access private
     * @var string
     */
    var $view_type = '';
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * 롼֥
     * 
     * @access private
     * @var object
     */
    var $router = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ饪֥
     */
    function SyL_Context(&$controller, &$data)
    {
        $this->controller =& $controller;
        $this->router     =& SyL_Router::getObject($data, SYL_ROUTER_RULE);
    }

    /**
     * ƥȤ
     *
     * @access public
     * @param object ȥ饪֥
     * @param object ǡ֥
     */
    function &getInstance(&$controller, &$data)
    {
        static $singleton;
        if (!is_object($singleton)) {
            $class_name = 'SyL_Context' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Context/{$class_name}.php";
            // ҥ饹Υ󥹥
            $singleton = new $class_name($controller, $data);
        }
        return $singleton;
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getActionName()
    {
        return is_object($this->router) ? $this->router->getActionName() : null;
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ
     */
    function getActionDir()
    {
        return $this->controller->getActionDir();
    }

    /**
     * ե
     *
     * @access public
     * @return string ե
     */
    function getActionFile()
    {
        return is_object($this->router) ? $this->router->getActionFile() : null;
    }

    /**
     * 饹̾
     *
     * @access public
     * @return string 饹̾
     */
    function getClassName()
    {
        return is_object($this->router) ? $this->router->getClassName() : null;
    }

    /**
     * PATH_INFO
     *
     * @access public
     * @return array PATH_INFO
     */
    function getPathInfoArray()
    {
        return is_object($this->router) ? $this->router->getPathInfoArray() : null;
    }

    /**
     * ӥ塼פ򥻥å
     *
     * @access public
     * @return string ӥ塼
     */
    function setViewType($view_type)
    {
        $this->view_type = $view_type;
    }

    /**
     * ӥ塼פ
     *
     * @access public
     * @return string ӥ塼
     */
    function getViewType()
    {
        return $this->view_type;
    }

    /**
     * ӥ塼ѥ᡼å
     * 
     * @access public
     * @param string ӥ塼ѥ᡼̾
     * @param string ӥ塼ѥ᡼
     */
    function setViewParameter($name, $value)
    {
        $this->view_parameters[$name] = $value;
    }

    /**
     * ե륿ͤ
     * 
     * @access public
     * @param string ե륿̾
     * @return mixed ե륿
     */
    function affectFilter($name)
    {
        // ե륿̾
        $name = "__filter_{$name}";
        // ե륿
        $component =& $this->controller->container->getComponent($name);
        if (!method_exists($component, $this->filter_method)) {
            trigger_error("[SyL error] Undefined filter method ({$this->filter_method})", E_USER_ERROR);
        }

        $args = func_get_args();
        array_shift($args);
        return call_user_func_array(array(&$component, $this->filter_method), $args);
    }

    /**
     * ݡͥȥ֥Ȥ򥻥å
     * 
     * @access public
     * @param string ݡͥ̾
     * @return object ݡͥ
     */
    function &getComponent($name)
    {
        return $this->controller->container->getComponent($name);
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param mixed ѥ᡼
     */
    function setParameter($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ѥ᡼
     */
    function &getParameters()
    {
        return $this->parameters;
    }

}

?>
